/*
 * Decompiled with CFR 0.152.
 */
package security.service;

import framework.config.UserConfig;
import framework.security.AuthService;
import security.utils.SecurityAuthUtil;

public class AuthServiceDefault
implements AuthService {
    private UserConfig userConfig;

    public AuthServiceDefault(UserConfig userConfig) {
        this.userConfig = userConfig;
    }

    public boolean isSupperAdmin() {
        Long superAdminId = this.userConfig.getSuperAdminId();
        if (superAdminId == null) {
            return false;
        }
        if (superAdminId == 0L) {
            return false;
        }
        Long accountId = this.getAccountId();
        if (accountId == null) {
            return false;
        }
        return superAdminId.equals(accountId);
    }

    public Long getAccountId() {
        Long authId = SecurityAuthUtil.getAccountId();
        if (authId == null) {
            return 0L;
        }
        return authId;
    }

    public boolean isAuthenticated() {
        Long accountId = this.getAccountId();
        return accountId != null && accountId > 0L;
    }

    public String getSecret() {
        String token = SecurityAuthUtil.getToken();
        return token;
    }

    public UserConfig getUserConfig() {
        return this.userConfig;
    }
}

