package security.service;

import framework.config.SecurityConfig;
import framework.security.AccountLoader;
import framework.security.token.AuthTokenBuilder;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;


public class SecurityContext {

    @Getter
    private final AccountLoader accountLoader;
    @Getter
    private final AuthTokenBuilder tokenBuilder;
    @Getter
    private final SecurityConfig securityConfig;
    @Getter
    private final AccountChecker accountChecker;
    @Getter
    private final FunctionPermissionLoader[] functionPermissionLoaders;
    @Getter
    private final Map<String, Object> state = new HashMap<>();

    public SecurityContext(AccountLoader accountLoader, SecurityConfig securityConfig, AuthTokenBuilder tokenBuilder, AccountChecker accountChecker, FunctionPermissionLoader[] functionPermissionLoaders) {
        this.accountChecker = accountChecker;
        this.securityConfig = securityConfig;
        this.tokenBuilder = tokenBuilder;
        this.accountLoader = accountLoader;
        this.functionPermissionLoaders = functionPermissionLoaders;
    }
}
