package security.config;

import framework.captcha.Captcha;
import framework.config.SecurityConfig;
import framework.config.UserConfig;
import framework.crypto.GeneralCrypto;
import framework.security.AccountLoader;
import framework.security.AuthService;
import framework.security.password.PasswordService;
import framework.security.token.AuthTokenBuilder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cache.CacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;
import security.service.*;

@Configuration
public class SecurityConfiguration {

    @Bean
    @ConditionalOnMissingBean
    public PasswordService passwordService(SecurityConfig securityConfig) {
        PasswordServiceDefault ps = new PasswordServiceDefault();
        if (StringUtils.hasText(securityConfig.getPasswordMode())) {
            ps.setDefaultMode(securityConfig.getPasswordMode());
        }
        return ps;
    }

    @Bean
    @ConditionalOnMissingBean
    public CaptchaFlagAdmin captchaFlagAdmin(CacheManager cacheManager) {
        return new CaptchaFlagAdminDefault(cacheManager);
    }

    @Bean
    @ConditionalOnMissingBean
    public AuthTokenBuilder authTokenBuilder(SecurityConfig securityConfig) {
        return new AuthTokenBuilderDefault(securityConfig);
    }

    @Bean
    @ConditionalOnMissingBean
    public AuthService authService(UserConfig userConfig) {
        return new AuthServiceDefault(userConfig);
    }

    @Bean
    @ConditionalOnMissingBean
    public LoginService loginService(
            SecurityConfig securityConfig,
            AccountLoader accountLoader,
            CaptchaFlagAdmin captchaFlagAdmin,
            GeneralCrypto generalCrypto,
            PasswordService passwordService,
            AuthTokenBuilder authTokenBuilder,
            AuthService authService,
            AccountChecker accountChecker,
            Captcha captcha) {
        return new LoginServiceDefault(securityConfig, accountLoader, captchaFlagAdmin, generalCrypto, passwordService, authTokenBuilder, authService, accountChecker, captcha);
    }

    @Bean
    @ConditionalOnMissingBean
    public AccountChecker accountChecker(AccountLoader accountLoader, PasswordService passwordService, SecurityConfig securityConfig, GeneralCrypto generalCrypto) {
        return new AccountCheckerDefault(accountLoader, passwordService, securityConfig, generalCrypto);
    }

    @Bean
    @ConditionalOnMissingBean
    public SecurityContext securityContext(AccountLoader accountLoader, SecurityConfig securityConfig, AuthTokenBuilder tokenBuilder, AccountChecker accountChecker, FunctionPermissionLoader[] functionPermissionLoaders) {
        return new SecurityContext(
                accountLoader,
                securityConfig,
                tokenBuilder,
                accountChecker,
                functionPermissionLoaders
        );
    }

}
