/*
 * Decompiled with CFR 0.152.
 */
package security.service;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.StringUtils;
import security.filters.FunctionPermissionHandler;

public class PathMatcher {
    private final Map<String, FunctionPermissionHandler> fullMatchMap = new HashMap<String, FunctionPermissionHandler>();
    private final Map<String, FunctionPermissionHandler> fullMatchMapOfMethod = new HashMap<String, FunctionPermissionHandler>();
    private final List<FunctionPermissionHandler> startMatchList = new ArrayList<FunctionPermissionHandler>();
    private final List<FunctionPermissionHandler> startMatchListOfMethod = new ArrayList<FunctionPermissionHandler>();
    private final AntPathMatcher antPathMatcher = new AntPathMatcher();

    public PathMatcher(List<FunctionPermissionHandler> functionPermissionHandlers) {
        if (functionPermissionHandlers != null) {
            for (FunctionPermissionHandler handler : functionPermissionHandlers) {
                if (!StringUtils.hasText((String)handler.getFunctionPermission().getPath())) continue;
                if (this.antPathMatcher.isPattern(handler.getFunctionPermission().getPath())) {
                    if (StringUtils.hasText((String)handler.getFunctionPermission().getMethod())) {
                        this.startMatchListOfMethod.add(handler);
                        continue;
                    }
                    this.startMatchList.add(handler);
                    continue;
                }
                if (StringUtils.hasText((String)handler.getFunctionPermission().getMethod())) {
                    this.fullMatchMapOfMethod.put(handler.getFunctionPermission().getMethod() + ":" + handler.getFunctionPermission().getPath(), handler);
                    continue;
                }
                this.fullMatchMap.put(handler.getFunctionPermission().getPath(), handler);
            }
        }
        this.startMatchList.sort(new Comparator<FunctionPermissionHandler>(){

            @Override
            public int compare(FunctionPermissionHandler o1, FunctionPermissionHandler o2) {
                return Integer.compare(o2.getFunctionPermission().getPath().length(), o1.getFunctionPermission().getPath().length());
            }
        });
        this.startMatchListOfMethod.sort(new Comparator<FunctionPermissionHandler>(){

            @Override
            public int compare(FunctionPermissionHandler o1, FunctionPermissionHandler o2) {
                return Integer.compare(o2.getFunctionPermission().getPath().length(), o1.getFunctionPermission().getPath().length());
            }
        });
    }

    public FunctionPermissionHandler match(String method, String path) {
        if (!StringUtils.hasText((String)path)) {
            return null;
        }
        if (!StringUtils.hasText((String)method)) {
            return null;
        }
        FunctionPermissionHandler functionPermission = this.fullMatchMapOfMethod.get(method + ":" + path);
        if (functionPermission != null) {
            return functionPermission;
        }
        functionPermission = this.fullMatchMap.get(path);
        if (functionPermission != null) {
            return functionPermission;
        }
        for (FunctionPermissionHandler fp : this.startMatchListOfMethod) {
            if (!method.equals(fp.getFunctionPermission().getMethod()) || !this.antPathMatcher.match(fp.getFunctionPermission().getPath(), path)) continue;
            return fp;
        }
        for (FunctionPermissionHandler fp : this.startMatchList) {
            if (!this.antPathMatcher.match(fp.getFunctionPermission().getPath(), path)) continue;
            return fp;
        }
        return null;
    }
}

