/*
 * Decompiled with CFR 0.152.
 */
package security.service;

import framework.captcha.Captcha;
import framework.config.SecurityConfig;
import framework.crypto.GeneralCrypto;
import framework.security.Account;
import framework.security.AccountLoader;
import framework.security.AuthCode;
import framework.security.AuthException;
import framework.security.AuthService;
import framework.security.LoginEntity;
import framework.security.password.PasswordService;
import framework.security.token.AuthTokenBuilder;
import framework.security.token.AuthTokenInfo;
import framework.utils.RequestUtil;
import framework.utils.ServletUtil;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.ServletRequestAttributes;
import security.service.AccountChecker;
import security.service.CaptchaFlagAdmin;
import security.service.LoginService;
import security.utils.SecurityAuthUtil;
import security.utils.SecurityCookieUtil;
import security.vo.LoginInfo;

public class LoginServiceDefault
implements LoginService {
    private final SecurityConfig securityConfig;
    private final AccountLoader accountLoader;
    private final CaptchaFlagAdmin captchaFlagAdmin;
    private final GeneralCrypto generalCrypto;
    private final PasswordService passwordService;
    private final AccountChecker accountChecker;
    private final AuthTokenBuilder authTokenBuilder;
    private final Captcha captcha;
    private final AuthService authService;

    public LoginServiceDefault(SecurityConfig securityConfig, AccountLoader accountLoader, CaptchaFlagAdmin captchaFlagAdmin, GeneralCrypto generalCrypto, PasswordService passwordService, AuthTokenBuilder authTokenBuilder, AuthService authService, AccountChecker accountChecker, Captcha captcha) {
        this.securityConfig = securityConfig;
        this.accountLoader = accountLoader;
        this.captchaFlagAdmin = captchaFlagAdmin;
        this.generalCrypto = generalCrypto;
        this.passwordService = passwordService;
        this.authTokenBuilder = authTokenBuilder;
        this.authService = authService;
        this.accountChecker = accountChecker;
        this.captcha = captcha;
    }

    protected void onLoginBefore(LoginEntity loginEntity, LoginInfo loginInfo) throws AuthException {
    }

    protected void onLoginFailed(LoginEntity loginEntity, AuthException exception) {
        if (exception.getAuthCode() != AuthCode.CAPTCHA_ERROR && exception.getAuthCode() != AuthCode.STATUS_UNAVAILABLE) {
            this.getAccountLoader().loginUnsuccessful(loginEntity.getUsername(), exception.getMessage());
        }
        if (StringUtils.hasText((String)loginEntity.getUsername())) {
            this.getCaptchaFlagAdmin().setFlag(loginEntity.getUsername());
        }
    }

    protected void onLoginSuccess(LoginEntity loginEntity, LoginInfo loginInfo) {
        this.getAccountLoader().loginSuccessful(loginEntity.getUsername(), loginInfo.getId());
        this.getCaptchaFlagAdmin().remove(loginEntity.getUsername());
    }

    protected void onLogoutBefore(Long accountId) throws AuthException {
    }

    protected void onLogoutSuccess(Long accountId) {
        this.getAccountLoader().logoutSuccessful(accountId);
    }

    protected void onLogoutFailed(Long accountId, AuthException exception) {
    }

    @Override
    public LoginInfo login(LoginEntity loginEntity) throws AuthException {
        LoginInfo loginInfo = new LoginInfo();
        try {
            this.doLogin(loginEntity, loginInfo);
        }
        catch (AuthException exception) {
            this.onLoginFailed(loginEntity, exception);
            throw exception;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage(), exception);
        }
        this.onLoginSuccess(loginEntity, loginInfo);
        return loginInfo;
    }

    private void doLogin(LoginEntity loginEntity, LoginInfo loginInfo) throws AuthException {
        Account account;
        this.onLoginBefore(loginEntity, loginInfo);
        if (this.getSecurityConfig().getEnableLoginCaptcha().booleanValue()) {
            boolean isCheckCaptcha;
            String captcha = loginEntity.getCaptcha();
            String captchaId = loginEntity.getCaptchaId();
            boolean bl = isCheckCaptcha = StringUtils.hasText((String)captchaId) && StringUtils.hasText((String)captcha);
            if (!isCheckCaptcha) {
                boolean bl2 = isCheckCaptcha = this.getSecurityConfig().getEnableLoginCaptcha() != false && this.getCaptchaFlagAdmin().hasFlag(loginEntity.getUsername());
            }
            if (isCheckCaptcha) {
                this.checkCaptcha(captchaId, captcha);
            }
        }
        try {
            account = this.getAccountChecker().authCheck(loginEntity.getUsername(), loginEntity.getPassword(), loginEntity.getPasswordCipher());
        }
        catch (AuthException exception) {
            if (this.getSecurityConfig().getEnableLoginCaptcha().booleanValue()) {
                this.getCaptchaFlagAdmin().setFlag(loginEntity.getUsername());
            }
            throw exception;
        }
        this.validRememberMe(loginEntity);
        this.createToken(loginEntity, loginInfo, account);
        if (!StringUtils.hasText((String)loginInfo.getToken())) {
            throw new AuthException("System error, not createToken");
        }
        this.doRememberMe(loginEntity, account, loginInfo.getToken());
        loginInfo.setId(account.getId());
        loginInfo.setName(account.getName());
        loginInfo.setUsername(loginEntity.getUsername());
        loginInfo.setPasswordChanged(account.passwordMustChanged() ? 1 : 0);
        this.fillSecurityContext(account, loginInfo.getToken());
    }

    protected void fillSecurityContext(Account account, String token) {
        SecurityAuthUtil.authorized(account.getId(), token);
    }

    @Override
    public void logout() throws AuthException {
        if (this.getAuthService().isAuthenticated()) {
            Long accountId = this.getAuthService().getAccountId();
            try {
                this.onLogoutBefore(accountId);
                this.doLogout(accountId);
            }
            catch (AuthException exception) {
                this.onLogoutFailed(accountId, exception);
                throw exception;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.getMessage(), exception);
            }
            this.onLogoutSuccess(accountId);
        }
    }

    private void doLogout(Long accountId) {
    }

    protected void checkCaptcha(String captchaId, String captcha) throws AuthException {
        if (!StringUtils.hasText((String)captcha)) {
            throw new AuthException(AuthCode.CAPTCHA_ERROR, RequestUtil.getMessageDefault((String)"security.captcha.empty", (String)"Please input captcha code", (Object[])new Object[0]));
        }
        if (!StringUtils.hasText((String)captchaId)) {
            throw new AuthException(AuthCode.REQUEST_INVALID, "Not set captchaId");
        }
        boolean checkSuccess = this.getCaptcha().check(captchaId, captcha);
        if (!checkSuccess) {
            throw new AuthException(AuthCode.CAPTCHA_ERROR, RequestUtil.getMessageDefault((String)"security.captcha.invalid", (String)"Captcha code error", (Object[])new Object[0]));
        }
        this.getCaptcha().remove(captchaId);
    }

    protected void doRememberMe(LoginEntity loginEntity, Account account, String token) throws AuthException {
        HttpServletRequest request;
        ServletRequestAttributes requestAttributes;
        if (loginEntity.getCookie() == null) {
            return;
        }
        if (loginEntity.getCookie() != 1) {
            return;
        }
        if (loginEntity.getRememberMe() == null) {
            return;
        }
        if (loginEntity.getRememberMe() < 0) {
            return;
        }
        Integer rememberMe = loginEntity.getRememberMe();
        SecurityConfig securityConfig = this.getSecurityConfig();
        ServletRequestAttributes attributes = ServletUtil.getRequestAttributes();
        if (attributes == null) {
            return;
        }
        HttpServletResponse response = attributes.getResponse();
        if (response == null) {
            return;
        }
        String cookieName = securityConfig.getTokenParamName();
        if (!StringUtils.hasText((String)cookieName)) {
            return;
        }
        String cookiePath = securityConfig.getCookiePath();
        if (!StringUtils.hasLength((String)cookiePath) && (requestAttributes = ServletUtil.getRequestAttributes()) != null && (request = requestAttributes.getRequest()) != null && StringUtils.hasText((String)request.getContextPath()) && !request.getContextPath().equals("/")) {
            cookiePath = request.getContextPath();
        }
        StringBuffer buffer = SecurityCookieUtil.buildCookie(securityConfig, cookieName, token, cookiePath, rememberMe);
        response.addHeader("Set-Cookie", buffer.toString());
    }

    protected void validRememberMe(LoginEntity loginEntity) {
        Integer maxRememberMe = this.securityConfig.getRememberMeMaxSeconds();
        Integer rememberMe = loginEntity.getRememberMe();
        if (rememberMe == null) {
            rememberMe = 0;
        } else if (rememberMe != 0 && maxRememberMe != null && maxRememberMe > 0 && rememberMe > maxRememberMe) {
            rememberMe = maxRememberMe;
        }
        loginEntity.setRememberMe(rememberMe);
    }

    protected void createToken(LoginEntity loginEntity, LoginInfo loginInfo, Account account) throws AuthException {
        Integer expires;
        Date now = new Date();
        if (loginEntity.getRememberMe() != null && loginEntity.getRememberMe() > 0) {
            expires = loginEntity.getRememberMe();
        } else {
            expires = this.getSecurityConfig().getTokenSeconds();
            if (expires == null) {
                throw new AuthException("Please config sys.security.token-seconds to application configuration");
            }
        }
        Date expireDate = new Date(now.getTime() + (long)(expires * 1000));
        String token = this.getAuthTokenBuilder().encode(new AuthTokenInfo(Long.valueOf(account.getId()), expireDate, expires));
        loginInfo.setToken(token);
        loginInfo.setTokenExpires(expires);
    }

    public SecurityConfig getSecurityConfig() {
        return this.securityConfig;
    }

    public AccountLoader getAccountLoader() {
        return this.accountLoader;
    }

    public CaptchaFlagAdmin getCaptchaFlagAdmin() {
        return this.captchaFlagAdmin;
    }

    public GeneralCrypto getGeneralCrypto() {
        return this.generalCrypto;
    }

    public PasswordService getPasswordService() {
        return this.passwordService;
    }

    public AccountChecker getAccountChecker() {
        return this.accountChecker;
    }

    public AuthTokenBuilder getAuthTokenBuilder() {
        return this.authTokenBuilder;
    }

    public Captcha getCaptcha() {
        return this.captcha;
    }

    public AuthService getAuthService() {
        return this.authService;
    }
}

