/*
 * Decompiled with CFR 0.152.
 */
package security.filters;

import framework.config.SecurityConfig;
import framework.security.Account;
import framework.security.FunctionPermission;
import framework.security.token.AuthTokenInfo;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import security.defined.AuthenticationCheckerResult;
import security.error.AuthenticationCheckerException;
import security.filters.AuthenticationData;
import security.filters.AuthenticationHandler;
import security.filters.FunctionPermissionHandler;
import security.service.FunctionPermissionLoader;
import security.service.PathMatcher;
import security.service.SecurityContext;

public abstract class AuthenticationBase {
    private static final Logger log = LoggerFactory.getLogger(AuthenticationBase.class);
    private final SecurityContext securityContext;
    private final SecurityConfig securityConfig;
    private final PathMatcher authPathMatcher;
    protected boolean corsDisabled = true;

    public AuthenticationBase(SecurityContext securityContext) {
        this.securityContext = securityContext;
        this.securityConfig = securityContext.getSecurityConfig();
        List<FunctionPermission> functionPermissionList = this.loadFunctionPermissionList();
        this.appendSecurityConfig(functionPermissionList);
        this.authPathMatcher = new PathMatcher(this.convertFunctionPermissionHandler(functionPermissionList));
    }

    protected List<FunctionPermissionHandler> convertFunctionPermissionHandler(List<FunctionPermission> functionPermissionList) {
        ArrayList<FunctionPermissionHandler> list = new ArrayList<FunctionPermissionHandler>();
        for (FunctionPermission functionPermission : functionPermissionList) {
            list.add(new FunctionPermissionHandler(functionPermission));
        }
        return list;
    }

    protected void appendSecurityConfig(List<FunctionPermission> functionPermissionList) {
        String pathAnonList = this.getSecurityConfig().getPathAnonList();
        String pathAuthList = this.getSecurityConfig().getPathAuthList();
        if (pathAnonList != null) {
            for (String path : pathAnonList.split(",")) {
                functionPermissionList.add(new FunctionPermission(path, "ANON", null));
            }
        }
        if (pathAuthList != null) {
            for (String path : pathAuthList.split(",")) {
                functionPermissionList.add(new FunctionPermission(path, "AUTH", null));
            }
        }
    }

    public AuthenticationData authCheck(AuthenticationHandler handler) throws AuthenticationCheckerException {
        List permissions;
        FunctionPermissionHandler functionPermissionHandler;
        if (this.isCorsDisabled() && "OPTIONS".equals(handler.getRequestMethod())) {
            return new AuthenticationData(0L, "", null);
        }
        String token = handler.getRequestToken();
        Date tokenExpired = null;
        Long id = 0L;
        if (StringUtils.hasText((String)token)) {
            AuthTokenInfo tokenInfo = null;
            if (token.startsWith("BASIC ")) {
                tokenInfo = this.basicParser(token);
            } else if (token.startsWith("TOKEN ")) {
                tokenInfo = this.tokenParser(token);
            }
            if (tokenInfo != null && !tokenInfo.isExpired()) {
                id = tokenInfo.getId();
                tokenExpired = tokenInfo.getExpireTime();
            }
        }
        if ((functionPermissionHandler = this.findFunctionMatcher(handler)) == null) {
            throw new AuthenticationCheckerException(AuthenticationCheckerResult.NO_PERMISSION);
        }
        if (this.hasAnonymous(handler, functionPermissionHandler)) {
            return new AuthenticationData(0L, "", tokenExpired);
        }
        if (id == null || id < 1L) {
            throw new AuthenticationCheckerException(AuthenticationCheckerResult.NO_AUTH);
        }
        if (!functionPermissionHandler.hasPermission("AUTH") && !this.hasPermissions(handler, permissions = this.getSecurityContext().getAccountLoader().loadPermissions(id), functionPermissionHandler)) {
            throw new AuthenticationCheckerException(AuthenticationCheckerResult.NO_PERMISSION);
        }
        AuthenticationData data = new AuthenticationData(id, token, tokenExpired);
        this.tokenReminder(data, handler);
        return data;
    }

    protected void tokenReminder(AuthenticationData data, AuthenticationHandler handler) {
        long sec;
        Integer tokenExpirationReminderSeconds = this.getSecurityConfig().getTokenExpirationReminderSeconds();
        if (data.getExpireTime() != null && tokenExpirationReminderSeconds != null && tokenExpirationReminderSeconds > 0 && (sec = (data.getExpireTime().getTime() - new Date().getTime()) / 1000L) < (long)tokenExpirationReminderSeconds.intValue()) {
            handler.tokenExpiredReminder((int)sec);
        }
    }

    protected boolean hasAnonymous(AuthenticationHandler handler, FunctionPermissionHandler functionPermissionHandler) {
        return functionPermissionHandler.hasPermission("ANON");
    }

    protected boolean hasPermissions(AuthenticationHandler handler, List<String> permissions, FunctionPermissionHandler functionPermissionHandler) {
        if (permissions == null) {
            return false;
        }
        if (permissions.size() == 0) {
            return false;
        }
        for (String permission : permissions) {
            if (permission == null || !functionPermissionHandler.hasPermission(permission)) continue;
            return true;
        }
        return false;
    }

    protected AuthTokenInfo tokenParser(String token) {
        AuthTokenInfo tokenInfo;
        try {
            token = token.substring(6);
            tokenInfo = this.getSecurityContext().getTokenBuilder().decode(token);
        }
        catch (Exception ex) {
            tokenInfo = null;
        }
        return tokenInfo;
    }

    protected AuthTokenInfo basicParser(String token) {
        AuthTokenInfo tokenInfo;
        block5: {
            tokenInfo = null;
            try {
                token = token.substring(6);
                byte[] decode = Base64.getDecoder().decode(token);
                String s = new String(decode, StandardCharsets.UTF_8);
                String[] strings = s.split(":", 2);
                if (strings.length != 2) break block5;
                Account account = null;
                try {
                    account = this.getSecurityContext().getAccountChecker().authCheck(strings[0], strings[1], null);
                }
                catch (Exception exception) {
                    this.getSecurityContext().getAccountLoader().loginUnsuccessful(strings[0], exception.getMessage());
                }
                if (account != null) {
                    tokenInfo = new AuthTokenInfo(Long.valueOf(account.getId()), account.accountExpired());
                }
            }
            catch (Exception ex) {
                tokenInfo = null;
            }
        }
        return tokenInfo;
    }

    protected FunctionPermissionHandler findFunctionMatcher(AuthenticationHandler handler) {
        String path = handler.getRequestPath();
        String method = handler.getRequestMethod();
        if ("".equals(path)) {
            path = "/";
        }
        return this.findFunctionMatcher(method, path);
    }

    protected FunctionPermissionHandler findFunctionMatcher(String method, String path) {
        return this.getAuthPathMatcher().match(method, path);
    }

    protected List<FunctionPermission> loadFunctionPermissionList() {
        ArrayList<FunctionPermission> functionPermissionList = this.getSecurityContext().getAccountLoader().loadFunctionPermission();
        if (functionPermissionList == null) {
            functionPermissionList = new ArrayList<FunctionPermission>();
        }
        if (this.getSecurityContext().getFunctionPermissionLoaders() != null) {
            for (FunctionPermissionLoader functionPermissionLoader : this.getSecurityContext().getFunctionPermissionLoaders()) {
                functionPermissionLoader.loading(functionPermissionList, this.getSecurityConfig());
            }
        }
        return functionPermissionList;
    }

    public SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public SecurityConfig getSecurityConfig() {
        return this.securityConfig;
    }

    public PathMatcher getAuthPathMatcher() {
        return this.authPathMatcher;
    }

    public boolean isCorsDisabled() {
        return this.corsDisabled;
    }
}

