package security.service;

import framework.config.UserConfig;
import framework.security.AuthService;
import lombok.Getter;
import security.utils.SecurityAuthUtil;

public class AuthServiceDefault implements AuthService {

    @Getter
    private UserConfig userConfig;

    public AuthServiceDefault(UserConfig userConfig) {
        this.userConfig = userConfig;
    }

    @Override
    public boolean isSupperAdmin() {
        Long superAdminId = this.userConfig.getSuperAdminId();
        if (superAdminId == null) return false;
        if (superAdminId == 0) return false;
        //
        Long accountId = this.getAccountId();
        if (accountId == null) return false;
        //
        return superAdminId.equals(accountId);
    }

    @Override
    public Long getAccountId() {
        Long authId = SecurityAuthUtil.getAccountId();
        if (authId == null) {
            return 0L;
        }
        return authId;
    }

    @Override
    public boolean isAuthenticated() {
        Long accountId = getAccountId();
        return accountId != null && accountId > 0L;
    }

    @Override
    public String getSecret() {
        String token = SecurityAuthUtil.getToken();
        return token;
    }

}
