/*
 * Decompiled with CFR 0.152.
 */
package security.service;

import framework.config.SecurityConfig;
import framework.crypto.GeneralCrypto;
import framework.security.Account;
import framework.security.AccountLoader;
import framework.security.AuthCode;
import framework.security.AuthException;
import framework.security.RegApproval;
import framework.security.password.PasswordService;
import framework.utils.RequestUtil;
import security.service.AccountChecker;

public class AccountCheckerDefault
implements AccountChecker {
    private final AccountLoader accountLoader;
    private final PasswordService passwordService;
    private final SecurityConfig securityConfig;
    private final GeneralCrypto generalCrypto;

    public AccountCheckerDefault(AccountLoader accountLoader, PasswordService passwordService, SecurityConfig securityConfig, GeneralCrypto generalCrypto) {
        this.accountLoader = accountLoader;
        this.passwordService = passwordService;
        this.securityConfig = securityConfig;
        this.generalCrypto = generalCrypto;
    }

    @Override
    public Account authCheck(String username, String password, String passwordCipher) {
        this.checkLoginLimit(username);
        Account account = this.loadAccount(username);
        this.checkAccountStatus(account);
        this.checkAccountPassword(account, password, passwordCipher);
        return account;
    }

    protected void checkLoginLimit(String username) throws AuthException {
        int loginFailLimit = this.getAccountLoader().loginFailLimit(username);
        if (loginFailLimit > 0) {
            throw new AuthException(AuthCode.STATUS_UNAVAILABLE, RequestUtil.getMessageDefault((String)"security.loginFailLimit", (String)"Login failure too many times, limit login {0} minutes", (Object[])new Object[]{(int)Math.ceil((double)loginFailLimit / 60.0) + ""}));
        }
    }

    protected void checkAccountStatus(Account account) throws AuthException {
        try {
            account.statusCheck();
        }
        catch (Exception exception) {
            throw new AuthException(AuthCode.STATUS_UNAVAILABLE, exception.getMessage());
        }
        if (account.getRegApproval() != null && !RegApproval.Agree.equals((Object)account.getRegApproval())) {
            if (RegApproval.Reject.equals((Object)account.getRegApproval())) {
                throw new AuthException(AuthCode.STATUS_UNAVAILABLE, RequestUtil.getMessageDefault((String)"security.userRejectApproved", (String)"Registration approval is rejected, the account is unavailable", (Object[])new Object[0]));
            }
            if (RegApproval.Waiting.equals((Object)account.getRegApproval())) {
                throw new AuthException(AuthCode.STATUS_UNAVAILABLE, RequestUtil.getMessageDefault((String)"security.userWaitingApproved", (String)"Waiting for registration approval, the account is unavailable", (Object[])new Object[0]));
            }
        }
    }

    protected void checkAccountPassword(Account account, String password, String passwordCipher) throws AuthException {
        String sourcePassword = this.passwordTransfer(account, password, passwordCipher);
        String salt = account.getPasswordSalt();
        String encodePassword = account.getPassword();
        if (!this.getPasswordService().matched(sourcePassword, salt, encodePassword)) {
            throw new AuthException(AuthCode.USERNAME_OR_PASSWORD_ERROR, RequestUtil.getMessageDefault((String)"security.userNotFound", (String)"username or password error", (Object[])new Object[0]));
        }
    }

    protected Account loadAccount(String username) {
        Account account = this.getAccountLoader().loadUserByUsername(username);
        if (account == null) {
            throw new AuthException(AuthCode.USERNAME_OR_PASSWORD_ERROR, RequestUtil.getMessageDefault((String)"security.userNotFound", (String)"username or password error", (Object[])new Object[0]));
        }
        return account;
    }

    protected String passwordTransfer(Account account, String password, String passwordCipher) {
        if (password == null) {
            throw new AuthException(AuthCode.USERNAME_OR_PASSWORD_ERROR, RequestUtil.getMessageDefault((String)"AbstractUserDetailsAuthenticationProvider.badCredentials", (String)"Bad credentials", (Object[])new Object[0]));
        }
        if ("gc".equals(passwordCipher)) {
            try {
                password = this.getGeneralCrypto().decryptFromBase64AsString(password);
            }
            catch (Exception exception) {
                throw new AuthException(AuthCode.REQUEST_INVALID, "Password decrypt failed, please refresh page and submit again");
            }
        }
        return password;
    }

    public AccountLoader getAccountLoader() {
        return this.accountLoader;
    }

    public PasswordService getPasswordService() {
        return this.passwordService;
    }

    public SecurityConfig getSecurityConfig() {
        return this.securityConfig;
    }

    public GeneralCrypto getGeneralCrypto() {
        return this.generalCrypto;
    }
}

