/*
 * Decompiled with CFR 0.152.
 */
package security.utils;

import framework.config.SecurityConfig;
import java.util.Objects;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.springframework.util.StringUtils;
import security.utils.TokenChannel;
import security.utils.TokenDetail;

public class SecurityTokenUtil {
    public static TokenDetail getRequestToken(HttpServletRequest request, SecurityConfig securityConfig) {
        String requestToken = request.getHeader("Authorization");
        boolean hasToken = StringUtils.hasLength((String)requestToken);
        if (hasToken && Objects.equals(true, securityConfig.getEnableBearerToken()) && requestToken.startsWith("Bearer ")) {
            return new TokenDetail(requestToken.substring(7), requestToken, TokenChannel.Bearer);
        }
        if (hasToken && Objects.equals(true, securityConfig.getEnableBasicAuth()) && requestToken.startsWith("Basic ")) {
            return new TokenDetail(requestToken.substring(6), requestToken, TokenChannel.Basic);
        }
        String tokenParamName = securityConfig.getTokenParamName();
        if (StringUtils.hasText((String)tokenParamName)) {
            String token = request.getParameter(tokenParamName);
            if (StringUtils.hasText((String)token)) {
                return new TokenDetail(token, TokenChannel.Bearer.name() + " " + token, TokenChannel.Query);
            }
            if (request.getCookies() != null) {
                for (Cookie cookie : request.getCookies()) {
                    if (!tokenParamName.equals(cookie.getName())) continue;
                    if (cookie.getValue() == null || !StringUtils.hasText((String)cookie.getValue())) break;
                    return new TokenDetail(cookie.getValue().trim(), TokenChannel.Bearer.name() + " " + cookie.getValue().trim(), TokenChannel.Cookie);
                }
            }
        }
        return null;
    }
}

