/*
 * Decompiled with CFR 0.152.
 */
package security.service;

import framework.config.SecurityConfig;
import framework.security.token.AuthTokenInfo;
import java.util.Date;
import java.util.Random;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import security.service.AuthTokenGenerator;

public class AuthTokenGeneratorDefault
implements AuthTokenGenerator {
    private String cacheName = "global";
    private final CacheManager cacheManager;

    public AuthTokenGeneratorDefault(SecurityConfig securityConfig, CacheManager cacheManager) {
        this.cacheManager = cacheManager;
        if (this.cacheManager == null) {
            throw new RuntimeException("Cache module not enable");
        }
    }

    @Override
    public long newSid(long id) {
        return Math.abs(new Random().nextLong()) % 0x1FFFFFFFFFFFFFL;
    }

    @Override
    public AuthTokenInfo newToken(long id, int duration, long sid) {
        Date expireDate = new Date(new Date().getTime() + (long)duration * 1000L);
        return new AuthTokenInfo(id, expireDate, duration, sid);
    }

    @Override
    public AuthTokenInfo updateToken(AuthTokenInfo tokenInfo) {
        Cache cache = this.cacheManager.getCache(this.getCacheName());
        if (cache == null) {
            throw new RuntimeException("Please config default settings in ehcache.xml");
        }
        String cacheKey = "AuthTokenGenerator_" + tokenInfo.getId() + "_" + tokenInfo.getSid();
        AuthTokenInfo info = (AuthTokenInfo)cache.get((Object)cacheKey, AuthTokenInfo.class);
        if (info != null && !this.isAllowUpdate(info)) {
            return info;
        }
        Date expired = new Date(new Date().getTime() + (long)tokenInfo.getDuration() * 1000L);
        AuthTokenInfo newInfo = new AuthTokenInfo(tokenInfo.getId(), expired, tokenInfo.getDuration(), tokenInfo.getSid());
        cache.put((Object)cacheKey, (Object)newInfo);
        return newInfo;
    }

    protected boolean isAllowUpdate(AuthTokenInfo info) {
        long threshold = 60L;
        if ((long)info.getDuration() < threshold) {
            return true;
        }
        long createTime = info.getExpireTime().getTime() - (long)info.getDuration() * 1000L;
        return new Date().getTime() - createTime > threshold * 1000L;
    }

    public String getCacheName() {
        return this.cacheName;
    }
}

