/*
 * Decompiled with CFR 0.152.
 */
package security.filters;

import framework.config.SecurityConfig;
import javax.servlet.FilterChain;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.util.StringUtils;
import security.filters.AuthenticationHandler;
import security.utils.SecurityCookieUtil;
import security.utils.SecurityTokenUtil;
import security.utils.TokenDetail;

public class AuthenticationServletHandler
implements AuthenticationHandler {
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final FilterChain filterChain;
    private final SecurityConfig securityConfig;

    public AuthenticationServletHandler(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain, SecurityConfig securityConfig) {
        this.request = request;
        this.response = response;
        this.filterChain = filterChain;
        this.securityConfig = securityConfig;
    }

    @Override
    public TokenDetail getRequestToken() {
        return SecurityTokenUtil.getRequestToken(this.request, this.securityConfig);
    }

    @Override
    public String getRequestPath() {
        return this.request.getServletPath();
    }

    @Override
    public String getRequestMethod() {
        return this.request.getMethod();
    }

    @Override
    public void tokenExpiredReminder(int seconds) {
        String tokenExpirationReminderHeader = this.securityConfig.getTokenExpirationReminderHeader();
        if (StringUtils.hasText((String)tokenExpirationReminderHeader)) {
            this.response.addHeader(tokenExpirationReminderHeader, "" + seconds);
        }
    }

    @Override
    public void tokenBalanceOutput(int seconds) {
        String tokenBalanceOutputHeader = this.securityConfig.getTokenBalanceOutputHeader();
        if (StringUtils.hasText((String)tokenBalanceOutputHeader)) {
            this.response.addHeader(tokenBalanceOutputHeader, "" + seconds);
        }
    }

    @Override
    public void saveTokenToCookie(String token) {
        String cookieName = this.securityConfig.getTokenParamName();
        if (!StringUtils.hasText((String)cookieName)) {
            return;
        }
        String cookiePath = this.securityConfig.getCookiePath();
        if (!StringUtils.hasText((String)cookiePath) && StringUtils.hasText((String)this.request.getContextPath()) && !this.request.getContextPath().equals("/")) {
            cookiePath = this.request.getContextPath();
        }
        Integer expires = this.securityConfig.getCookieMaxAge();
        StringBuffer buffer = SecurityCookieUtil.buildCookie(this.securityConfig, cookieName, token, cookiePath, expires);
        this.response.addHeader("Set-Cookie", buffer.toString());
    }
}

