/*
 * Decompiled with CFR 0.152.
 */
package security.filters;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.apache.commons.lang3.StringUtils;
import tk.mybatis.mapper.util.Assert;

public class AuthenticationData {
    private long id;
    private String token;
    private long sid;

    public AuthenticationData(long id, String token, long sid) {
        this.id = id;
        this.sid = sid;
        this.token = token != null ? token : "";
    }

    public String toBase64() {
        byte[] tbs = this.token.getBytes(StandardCharsets.UTF_8);
        ByteBuffer buffer = ByteBuffer.allocate(tbs.length + 16);
        buffer.putLong(this.id);
        buffer.putLong(this.sid);
        if (tbs.length > 0) {
            buffer.put(tbs);
        }
        return Base64.getEncoder().encodeToString(buffer.array());
    }

    public static AuthenticationData fromBase64(String base64) {
        byte[] bytes;
        if (StringUtils.isBlank((CharSequence)base64)) {
            return null;
        }
        try {
            bytes = Base64.getDecoder().decode(base64);
        }
        catch (Exception exception) {
            return null;
        }
        String token = "";
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        long id = buffer.getLong();
        long sid = buffer.getLong();
        if (buffer.remaining() > 0) {
            byte[] tbs = new byte[buffer.remaining()];
            buffer.get(tbs);
            token = new String(tbs, StandardCharsets.UTF_8);
        }
        return new AuthenticationData(id, token, sid);
    }

    public static void main(String[] args) {
        String base64 = new AuthenticationData(1765446464L, "tokenGT", 245646464L).toBase64();
        System.out.println(base64);
        AuthenticationData authenticationData = AuthenticationData.fromBase64(base64);
        assert (authenticationData != null);
        System.out.printf("%d, %s ,%d \r\n", authenticationData.getId(), authenticationData.getToken(), authenticationData.getSid());
        Assert.isTrue((authenticationData.getId() == 1765446464L && authenticationData.getToken().equals("tokenGT") && authenticationData.getSid() == 245646464L ? 1 : 0) != 0, (String)"AuthenticationData serialization fail");
        base64 = new AuthenticationData(1765446464L, null, 245646464L).toBase64();
        System.out.println(base64);
        authenticationData = AuthenticationData.fromBase64(base64);
        assert (authenticationData != null);
        System.out.printf("%d, %s ,%d \r\n", authenticationData.getId(), authenticationData.getToken(), authenticationData.getSid());
        Assert.isTrue((authenticationData.getId() == 1765446464L && "".equals(authenticationData.getToken()) && authenticationData.getSid() == 245646464L ? 1 : 0) != 0, (String)"AuthenticationData serialization fail");
    }

    public long getId() {
        return this.id;
    }

    public String getToken() {
        return this.token;
    }

    public long getSid() {
        return this.sid;
    }
}

