/*
 * Decompiled with CFR 0.152.
 */
package security.filters;

import framework.config.SecurityConfig;
import framework.security.Account;
import framework.security.FunctionPermission;
import framework.security.token.AuthTokenInfo;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import security.defined.AuthenticationCheckerResult;
import security.error.AuthenticationCheckerException;
import security.filters.AuthenticationData;
import security.filters.AuthenticationHandler;
import security.filters.FunctionPermissionHandler;
import security.service.FunctionPermissionLoader;
import security.service.PathMatcher;
import security.service.SecurityContext;
import security.utils.TokenChannel;
import security.utils.TokenDetail;

public abstract class AuthenticationBase {
    private static final Logger log = LoggerFactory.getLogger(AuthenticationBase.class);
    private final SecurityContext securityContext;
    private final SecurityConfig securityConfig;
    private final PathMatcher authPathMatcher;
    protected boolean corsDisabled;

    public AuthenticationBase(SecurityContext securityContext) {
        this.securityContext = securityContext;
        this.securityConfig = securityContext.getSecurityConfig();
        this.corsDisabled = securityContext.getSecurityConfig().getCorsAuth() == false;
        List<FunctionPermission> functionPermissionList = this.loadFunctionPermissionList();
        this.appendSecurityConfig(functionPermissionList);
        this.authPathMatcher = new PathMatcher(this.convertFunctionPermissionHandler(functionPermissionList));
    }

    protected List<FunctionPermissionHandler> convertFunctionPermissionHandler(List<FunctionPermission> functionPermissionList) {
        ArrayList<FunctionPermissionHandler> list = new ArrayList<FunctionPermissionHandler>();
        for (FunctionPermission functionPermission : functionPermissionList) {
            list.add(new FunctionPermissionHandler(functionPermission));
        }
        return list;
    }

    protected void appendSecurityConfig(List<FunctionPermission> functionPermissionList) {
        String pathAnonList = this.getSecurityConfig().getPathAnonList();
        String pathAuthList = this.getSecurityConfig().getPathAuthList();
        if (pathAnonList != null) {
            for (String path : pathAnonList.split(",")) {
                functionPermissionList.add(new FunctionPermission(path, "ANON", null));
            }
        }
        if (pathAuthList != null) {
            for (String path : pathAuthList.split(",")) {
                functionPermissionList.add(new FunctionPermission(path, "AUTH", null));
            }
        }
    }

    public AuthenticationData authCheck(AuthenticationHandler handler) throws AuthenticationCheckerException {
        FunctionPermissionHandler functionPermissionHandler;
        AuthenticationData corsData = this.checkCors(handler);
        if (corsData != null) {
            return corsData;
        }
        TokenDetail tokenDetail = handler.getRequestToken();
        AuthTokenInfo tokenInfo = null;
        String secret = "";
        long id = 0L;
        long sid = 0L;
        if (tokenDetail != null) {
            switch (tokenDetail.getChannel()) {
                case Basic: {
                    Account account = this.basicParser(tokenDetail.getToken());
                    id = account.getId();
                    secret = "Password: ******";
                    break;
                }
                case Bearer: 
                case Query: 
                case Cookie: {
                    tokenInfo = this.tokenParser(tokenDetail.getToken());
                    if (tokenInfo != null && !tokenInfo.isExpired() && this.validateSid(tokenInfo)) {
                        id = tokenInfo.getId();
                        sid = tokenInfo.getSid();
                        secret = tokenDetail.getSecret();
                        break;
                    }
                    tokenInfo = null;
                    break;
                }
            }
        }
        if ((functionPermissionHandler = this.findFunctionMatcher(handler)) == null) {
            throw new AuthenticationCheckerException(AuthenticationCheckerResult.NO_PERMISSION);
        }
        if (this.hasAnonymous(handler, functionPermissionHandler)) {
            return new AuthenticationData(0L, "", 0L);
        }
        if (functionPermissionHandler.hasPermission("PERMIT")) {
            return new AuthenticationData(id, secret, sid);
        }
        if (id < 1L) {
            throw new AuthenticationCheckerException(AuthenticationCheckerResult.NO_AUTH);
        }
        if (tokenInfo != null) {
            this.tokenReminder(tokenInfo, handler);
            this.tokenBalance(tokenInfo, handler);
        }
        if (tokenInfo != null && tokenDetail.getChannel() == TokenChannel.Cookie) {
            this.updateTokenToCookie(tokenInfo, handler);
        }
        if (functionPermissionHandler.hasPermission("AUTH")) {
            return new AuthenticationData(id, secret, sid);
        }
        List permissions = this.getSecurityContext().getAccountLoader().loadPermissions(Long.valueOf(id));
        if (!this.hasPermissions(handler, permissions, functionPermissionHandler)) {
            throw new AuthenticationCheckerException(AuthenticationCheckerResult.NO_PERMISSION);
        }
        return new AuthenticationData(id, secret, sid);
    }

    protected void updateTokenToCookie(AuthTokenInfo tokenInfo, AuthenticationHandler handler) {
        if (this.getSecurityConfig().getCookieTokenRenew() == null) {
            return;
        }
        if (this.getSecurityConfig().getCookieTokenRenew() == 0) {
            return;
        }
        if (this.getSecurityConfig().getCookieTokenRenew() > 99 || this.getSecurityConfig().getCookieTokenRenew() < 1) {
            throw new RuntimeException("cookie-token-renew value allow 1-99, suggest config is 60");
        }
        long margin = (tokenInfo.getExpireTime().getTime() - new Date().getTime()) / 1000L;
        if (margin > 0L) {
            double threshold = (double)tokenInfo.getDuration() * ((double)this.getSecurityConfig().getCookieTokenRenew().intValue() / 100.0);
            if ((double)((long)tokenInfo.getDuration() - margin) > threshold) {
                AuthTokenInfo newToken = this.createNewTokenOfCookieUpdate(tokenInfo);
                String token = this.getSecurityContext().getTokenBuilder().encode(newToken);
                handler.saveTokenToCookie(token);
            }
        }
    }

    protected AuthTokenInfo createNewTokenOfCookieUpdate(AuthTokenInfo tokenInfo) {
        return this.getSecurityContext().getTokenGenerator().updateToken(tokenInfo);
    }

    protected boolean validateSid(AuthTokenInfo tokenInfo) {
        return true;
    }

    protected AuthenticationData checkCors(AuthenticationHandler handler) {
        String requestMethod = handler.getRequestMethod();
        if ("OPTIONS".equals(requestMethod)) {
            return new AuthenticationData(0L, "", 0L);
        }
        return null;
    }

    protected void tokenBalance(AuthTokenInfo tokenInfo, AuthenticationHandler handler) {
        String tokenBalanceOutputHeader = this.getSecurityConfig().getTokenBalanceOutputHeader();
        if (StringUtils.hasText((String)tokenBalanceOutputHeader)) {
            long sec = (tokenInfo.getExpireTime().getTime() - new Date().getTime()) / 1000L;
            handler.tokenBalanceOutput((int)sec);
        }
    }

    protected void tokenReminder(AuthTokenInfo tokenInfo, AuthenticationHandler handler) {
        long sec;
        Integer tokenExpirationReminderSeconds = this.getSecurityConfig().getTokenExpirationReminderSeconds();
        Double tokenExpirationReminderPercent = this.getSecurityConfig().getTokenExpirationReminderPercent();
        if (tokenInfo.getExpireTime() != null && tokenExpirationReminderSeconds != null && tokenExpirationReminderSeconds > 0) {
            long sec2 = (tokenInfo.getExpireTime().getTime() - new Date().getTime()) / 1000L;
            if (sec2 < (long)tokenExpirationReminderSeconds.intValue()) {
                handler.tokenExpiredReminder((int)sec2);
            }
        } else if (tokenInfo.getExpireTime() != null && tokenInfo.getDuration() > 0 && tokenExpirationReminderPercent != null && tokenExpirationReminderPercent > 0.0 && (sec = (tokenInfo.getExpireTime().getTime() - new Date().getTime()) / 1000L) > 0L) {
            double threshold = (double)tokenInfo.getDuration() * (tokenExpirationReminderPercent / 100.0);
            if ((double)((long)tokenInfo.getDuration() - sec) > threshold) {
                handler.tokenExpiredReminder((int)sec);
            }
        }
    }

    protected boolean hasAnonymous(AuthenticationHandler handler, FunctionPermissionHandler functionPermissionHandler) {
        return functionPermissionHandler.hasPermission("ANON");
    }

    protected boolean hasPermissions(AuthenticationHandler handler, List<String> permissions, FunctionPermissionHandler functionPermissionHandler) {
        if (permissions == null) {
            return false;
        }
        if (permissions.size() == 0) {
            return false;
        }
        for (String permission : permissions) {
            if (permission == null || !functionPermissionHandler.hasPermission(permission)) continue;
            return true;
        }
        return false;
    }

    protected AuthTokenInfo tokenParser(String token) {
        AuthTokenInfo tokenInfo;
        if (!StringUtils.hasText((String)token)) {
            return null;
        }
        try {
            tokenInfo = this.getSecurityContext().getTokenBuilder().decode(token);
        }
        catch (Exception ex) {
            tokenInfo = null;
        }
        return tokenInfo;
    }

    protected Account basicParser(String token) {
        if (!StringUtils.hasText((String)token)) {
            return null;
        }
        Account account = null;
        try {
            byte[] decode = Base64.getDecoder().decode(token);
            String s = new String(decode, StandardCharsets.UTF_8);
            String[] strings = s.split(":", 2);
            if (strings.length == 2) {
                try {
                    account = this.getSecurityContext().getAccountChecker().authCheck(strings[0], strings[1], null);
                }
                catch (Exception exception) {
                    this.getSecurityContext().getAccountLoader().loginUnsuccessful(strings[0], exception.getMessage());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return account;
    }

    protected FunctionPermissionHandler findFunctionMatcher(AuthenticationHandler handler) {
        String path = handler.getRequestPath();
        String method = handler.getRequestMethod();
        if ("".equals(path)) {
            path = "/";
        }
        return this.findFunctionMatcher(method, path);
    }

    protected FunctionPermissionHandler findFunctionMatcher(String method, String path) {
        return this.getAuthPathMatcher().match(method, path);
    }

    protected List<FunctionPermission> loadFunctionPermissionList() {
        ArrayList<FunctionPermission> functionPermissionList = this.getSecurityContext().getAccountLoader().loadFunctionPermission();
        if (functionPermissionList == null) {
            functionPermissionList = new ArrayList<FunctionPermission>();
        }
        if (this.getSecurityContext().getFunctionPermissionLoaders() != null) {
            for (FunctionPermissionLoader functionPermissionLoader : this.getSecurityContext().getFunctionPermissionLoaders()) {
                functionPermissionLoader.loading(functionPermissionList, this.getSecurityConfig());
            }
        }
        return functionPermissionList;
    }

    public SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public SecurityConfig getSecurityConfig() {
        return this.securityConfig;
    }

    public PathMatcher getAuthPathMatcher() {
        return this.authPathMatcher;
    }

    public boolean isCorsDisabled() {
        return this.corsDisabled;
    }
}

