/*
 * Decompiled with CFR 0.152.
 */
package security.filters;

import framework.config.SecurityConfig;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import security.filters.AuthenticationData;
import security.utils.SecurityAuthUtil;
import security.utils.SecurityTokenUtil;
import security.utils.TokenDetail;

public class AuthIdentityServletFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(AuthIdentityServletFilter.class);
    private SecurityConfig securityConfig;
    public final String authIdentityHeaderName;

    public AuthIdentityServletFilter(SecurityConfig securityConfig) {
        this.securityConfig = securityConfig;
        String identityHeader = securityConfig.getAuthIdentityHeader();
        if (!StringUtils.hasText((String)identityHeader)) {
            throw new IllegalArgumentException("Not configuration sys.security.auth_identity_header");
        }
        this.authIdentityHeaderName = identityHeader;
    }

    protected AuthenticationData parseAuthIdentity(HttpServletRequest request) {
        String identity = request.getHeader(this.authIdentityHeaderName);
        if (StringUtils.hasText((String)identity)) {
            try {
                return AuthenticationData.fromBase64(identity);
            }
            catch (Exception exception) {
                log.error("parse auth identity error " + exception.getMessage(), (Throwable)exception);
                return null;
            }
        }
        return null;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        TokenDetail tokenDetail;
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        AuthenticationData data = this.parseAuthIdentity(request);
        if (data == null) {
            data = new AuthenticationData(0L, "", 0L);
        }
        if (data.getId() == 0L && this.getSecurityConfig().getDebugAccountId() != null) {
            data = new AuthenticationData(this.getSecurityConfig().getDebugAccountId(), "{DEBUG}", 0L);
        }
        if ((tokenDetail = SecurityTokenUtil.getRequestToken(request, this.getSecurityConfig())) == null) {
            response.sendError(500, "illegal access, gateway and application authentication failed");
            return;
        }
        SecurityAuthUtil.authorized(data);
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public SecurityConfig getSecurityConfig() {
        return this.securityConfig;
    }
}

