package security.service;

import framework.config.SecurityConfig;
import framework.security.AccountLoader;
import framework.security.AuthService;
import framework.security.password.PasswordService;
import framework.security.token.AuthTokenBuilder;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;


public class SecurityContext {

    @Getter
    private final AccountLoader accountLoader;
    @Getter
    private final AuthService authService;
    @Getter
    private final PasswordService passwordService;
    @Getter
    private final AuthTokenBuilder tokenBuilder;
    @Getter
    private final AuthTokenGenerator tokenGenerator;
    @Getter
    private final SecurityConfig securityConfig;
    @Getter
    private final AccountChecker accountChecker;
    @Getter
    private final FunctionPermissionLoader[] functionPermissionLoaders;
    @Getter
    private final Map<String, Object> state = new HashMap<>();

    public SecurityContext(AccountLoader accountLoader
            , AuthService authService
            , PasswordService passwordService
            , SecurityConfig securityConfig
            , AuthTokenBuilder tokenBuilder
            , AccountChecker accountChecker
            , FunctionPermissionLoader[] functionPermissionLoaders
            , AuthTokenGenerator tokenGenerator) {
        this.accountChecker = accountChecker;
        this.authService = authService;
        this.passwordService = passwordService;
        this.securityConfig = securityConfig;
        this.tokenBuilder = tokenBuilder;
        this.accountLoader = accountLoader;
        this.functionPermissionLoaders = functionPermissionLoaders;
        this.tokenGenerator = tokenGenerator;
    }
}
