package security.service;

import framework.security.token.AuthTokenInfo;

public interface AuthTokenGenerator {

    /**
     * 创建新的SID
     *
     * @return
     */
    long newSid(long id);

    /**
     * 新的token，通常用于登录时
     *
     * @param id
     * @param duration
     * @param sid
     * @return
     */
    AuthTokenInfo newToken(long id, int duration, long sid);

    /**
     * 更新token，通常用于令牌更新
     *
     * @param tokenInfo
     * @return
     */
    AuthTokenInfo updateToken(AuthTokenInfo tokenInfo);

}
