package security.service;

import framework.config.UserConfig;
import framework.security.AuthService;
import lombok.Getter;
import security.utils.SecurityAuthUtil;

public class AuthServiceDefault implements AuthService {

    @Getter
    private UserConfig userConfig;

    public AuthServiceDefault(UserConfig userConfig) {
        this.userConfig = userConfig;
    }

    @Override
    public boolean isSupperAdmin() {
        Long superAdminId = this.userConfig.getSuperAdminId();
        if (superAdminId == null) return false;
        if (superAdminId == 0) return false;
        //
        return superAdminId.equals(this.getAccountId());
    }

    @Override
    public long getAccountId() {
        return SecurityAuthUtil.getAccountId();
    }

    @Override
    public boolean isAuthenticated() {
        long accountId = getAccountId();
        return accountId > 0L;
    }

    @Override
    public String getSecret() {
        return SecurityAuthUtil.getToken();
    }

    @Override
    public long getSid() {
        return SecurityAuthUtil.getSid();
    }

}
