/*
 * Decompiled with CFR 0.152.
 */
package security.filters;

import framework.config.SecurityConfig;
import framework.security.AccountLoader;
import framework.security.token.AuthTokenBuilder;
import framework.utils.RequestUtil;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import security.defined.AuthenticationCheckerResult;
import security.error.AuthenticationCheckerException;
import security.filters.AuthenticationBase;
import security.filters.AuthenticationData;
import security.filters.AuthenticationHandler;
import security.filters.AuthenticationServletHandler;
import security.utils.SecurityAuthUtil;

public class AuthenticationServletFilter
extends AuthenticationBase
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(AuthenticationServletFilter.class);

    public AuthenticationServletFilter(AccountLoader accountLoader, SecurityConfig securityConfig, AuthTokenBuilder tokenBuilder) {
        super(accountLoader, securityConfig, tokenBuilder);
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain filterChain) throws IOException, ServletException {
        if (this.getSecurityConfig().getEnable().booleanValue()) {
            AuthenticationData data;
            HttpServletRequest request = (HttpServletRequest)req;
            HttpServletResponse response = (HttpServletResponse)resp;
            try {
                data = this.authCheck(this.createAuthenticationHandler(request, response, filterChain, this.getSecurityConfig()));
            }
            catch (AuthenticationCheckerException authenticationCheckerException) {
                if (AuthenticationCheckerResult.NO_AUTH.equals((Object)authenticationCheckerException.getStatus())) {
                    if (StringUtils.hasText((String)this.getSecurityConfig().getRedirectOnNoAuth())) {
                        response.sendRedirect(this.getSecurityConfig().getRedirectOnNoAuth());
                    } else {
                        response.sendError(401, RequestUtil.getMessageDefault((String)"error.e401", (String)"Unauthorized", (Object[])new Object[0]));
                    }
                } else if (AuthenticationCheckerResult.NO_PERMISSION.equals((Object)authenticationCheckerException.getStatus())) {
                    if (StringUtils.hasText((String)this.getSecurityConfig().getRedirectOnNoPermission())) {
                        response.sendRedirect(this.getSecurityConfig().getRedirectOnNoPermission());
                    } else {
                        response.sendError(405, RequestUtil.getMessageDefault((String)"error.e405", (String)"No permission", (Object[])new Object[0]));
                    }
                } else if (StringUtils.hasText((String)this.getSecurityConfig().getRedirectOnAuthError())) {
                    response.sendRedirect(this.getSecurityConfig().getRedirectOnAuthError());
                } else {
                    response.sendError(500, authenticationCheckerException.getMessage());
                }
                return;
            }
            catch (Throwable throwable) {
                log.error("Authentication valid error," + throwable.getMessage(), throwable);
                if (StringUtils.hasText((String)this.getSecurityConfig().getRedirectOnAuthError())) {
                    response.sendRedirect(this.getSecurityConfig().getRedirectOnAuthError());
                } else {
                    response.sendError(401, throwable.getMessage());
                }
                return;
            }
            if (data != null && data.getId() != null) {
                SecurityAuthUtil.authorized(data.getId(), data.getToken());
                filterChain.doFilter(req, resp);
            } else {
                response.sendError(401, "Unauthorized of server error");
            }
        } else {
            filterChain.doFilter(req, resp);
        }
    }

    protected AuthenticationHandler createAuthenticationHandler(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain, SecurityConfig securityConfig) {
        return new AuthenticationServletHandler(request, response, filterChain, this.getSecurityConfig());
    }
}

