/*
 * Decompiled with CFR 0.152.
 */
package security.config;

import framework.config.SecurityConfig;
import framework.config.UserConfig;
import framework.security.AuthService;
import framework.security.password.PasswordService;
import framework.security.token.AuthTokenBuilder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cache.CacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;
import security.service.AuthServiceDefault;
import security.service.AuthTokenBuilderDefault;
import security.service.CaptchaFlagAdmin;
import security.service.CaptchaFlagAdminDefault;
import security.service.PasswordServiceDefault;

@Configuration
public class SecurityConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public PasswordService passwordService(SecurityConfig securityConfig) {
        PasswordServiceDefault ps = new PasswordServiceDefault();
        if (StringUtils.hasText((String)securityConfig.getPasswordMode())) {
            ps.setDefaultMode(securityConfig.getPasswordMode());
        }
        return ps;
    }

    @Bean
    @ConditionalOnMissingBean
    public CaptchaFlagAdmin captchaFlagAdmin(CacheManager cacheManager) {
        return new CaptchaFlagAdminDefault(cacheManager);
    }

    @Bean
    @ConditionalOnMissingBean
    public AuthTokenBuilder authTokenBuilder(SecurityConfig securityConfig) {
        return new AuthTokenBuilderDefault(securityConfig);
    }

    @Bean
    @ConditionalOnMissingBean
    public AuthService authService(UserConfig userConfig) {
        return new AuthServiceDefault(userConfig);
    }
}

