package security.utils;

import org.springframework.util.StringUtils;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

/**
 * 安全组件TOKEN工具
 */
public class SecurityTokenUtil {
    /**
     * 获取令牌
     *
     * @param request
     * @return
     */
    public static String getRequestToken(HttpServletRequest request) {
        String bearerToken = request.getHeader("Authorization");
        String token;
        if (StringUtils.hasLength(bearerToken) && bearerToken.startsWith("Bearer ")) {
            token = bearerToken.substring(7);
        } else if (StringUtils.hasLength(request.getParameter("TOKEN"))) {
            token = request.getParameter("TOKEN");
        } else {
            token = null;
            if (request.getCookies() != null) {
                for (Cookie cookie : request.getCookies()) {
                    if ("TOKEN".equals(cookie.getName())) {
                        if (cookie.getValue() != null) {
                            token = cookie.getValue().trim();
                        }
                        break;
                    }
                }
            }
        }
        return token;
    }

}
