package security.utils;

import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

/**
 * 授权工具
 */
public class SecurityAuthUtil {

    /**
     * 账号ID
     */
    private static final String KEY_ACCOUNT_ID = "SECURITY-AUTH-UTIL-ID";

    /**
     * 账号令牌
     */
    private static final String KEY_TOKEN = "SECURITY-AUTH-UTIL-TOKEN";

    /**
     * 授权完成后的属性写入
     *
     * @param accountId
     * @param token
     */
    public static void authorized(Long accountId, String token) {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        requestAttributes.setAttribute(KEY_ACCOUNT_ID, accountId, RequestAttributes.SCOPE_REQUEST);
        requestAttributes.setAttribute(KEY_TOKEN, token, RequestAttributes.SCOPE_REQUEST);
    }

    /**
     * 获取当前授权的用户ID
     *
     * @return
     */
    public static final Long getAccountId() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        return (Long) requestAttributes.getAttribute(KEY_ACCOUNT_ID, RequestAttributes.SCOPE_REQUEST);
    }

    /**
     * 获取当前授权的TOKEN
     *
     * @return
     */
    public static final String getToken() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        return (String) requestAttributes.getAttribute(KEY_TOKEN, RequestAttributes.SCOPE_REQUEST);
    }
}
