package security.filters;

import framework.config.SecurityConfig;
import security.utils.SecurityTokenUtil;

import javax.servlet.FilterChain;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 应用于Servlet的授权处理器
 */
public class AuthenticationServletHandler implements AuthenticationHandler {

    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final FilterChain filterChain;
    private final SecurityConfig securityConfig;

    public AuthenticationServletHandler(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain, SecurityConfig securityConfig) {
        this.request = request;
        this.response = response;
        this.filterChain = filterChain;
        this.securityConfig = securityConfig;
    }

    /**
     * get token
     *
     * @return
     */
    @Override
    public String getRequestToken() {
        return SecurityTokenUtil.getRequestToken(this.request);
    }

    /**
     * 获取请求路径
     *
     * @return
     */
    @Override
    public String getRequestPath() {
        return request.getServletPath();
    }

    /**
     * 获取请求方法
     *
     * @return
     */
    @Override
    public String getRequestMethod() {
        return request.getMethod();
    }

}
