package security.error;

import lombok.Getter;
import security.defined.AuthenticationCheckerResult;

/**
 * 授权异常
 */
public class AuthenticationCheckerException extends Exception {

    @Getter
    private AuthenticationCheckerResult status;

    public AuthenticationCheckerException(AuthenticationCheckerResult status) {
        super(status.name());
        this.status = status;
    }

    public AuthenticationCheckerException(AuthenticationCheckerResult status, String message) {
        super(message);
        this.status = status;
    }
}
