/*
 * Decompiled with CFR 0.152.
 */
package security.utils;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.springframework.util.StringUtils;

public class SecurityTokenUtil {
    public static String getRequestToken(HttpServletRequest request) {
        String token;
        String bearerToken = request.getHeader("Authorization");
        if (StringUtils.hasLength((String)bearerToken) && bearerToken.startsWith("Bearer ")) {
            token = bearerToken.substring(7);
        } else if (StringUtils.hasLength((String)request.getParameter("TOKEN"))) {
            token = request.getParameter("TOKEN");
        } else {
            token = null;
            if (request.getCookies() != null) {
                for (Cookie cookie : request.getCookies()) {
                    if (!"TOKEN".equals(cookie.getName())) continue;
                    if (cookie.getValue() == null) break;
                    token = cookie.getValue().trim();
                    break;
                }
            }
        }
        return token;
    }
}

