/*
 * Decompiled with CFR 0.152.
 */
package security.filters;

import framework.config.SecurityConfig;
import framework.security.AccountLoader;
import framework.security.FunctionPermission;
import framework.security.token.AuthTokenBuilder;
import framework.security.token.AuthTokenInfo;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import security.defined.AuthenticationCheckerResult;
import security.error.AuthenticationCheckerException;
import security.filters.AuthenticationData;
import security.filters.AuthenticationHandler;
import security.filters.FunctionPermissionHandler;
import security.service.PathMatcher;

public abstract class AuthenticationBase {
    private static final Logger log = LoggerFactory.getLogger(AuthenticationBase.class);
    private final PathMatcher authPathMatcher;
    private final AccountLoader accountLoader;
    private final AuthTokenBuilder tokenBuilder;
    private final SecurityConfig securityConfig;
    protected boolean corsDisabled = true;

    public AuthenticationBase(AccountLoader accountLoader, SecurityConfig securityConfig, AuthTokenBuilder tokenBuilder) {
        this.accountLoader = accountLoader;
        this.securityConfig = securityConfig;
        this.tokenBuilder = tokenBuilder;
        List<FunctionPermission> functionPermissionList = this.loadFunctionPermissionList();
        this.appendSecurityConfig(functionPermissionList);
        this.authPathMatcher = new PathMatcher(this.convertFunctionPermissionHandler(functionPermissionList));
    }

    protected List<FunctionPermissionHandler> convertFunctionPermissionHandler(List<FunctionPermission> functionPermissionList) {
        ArrayList<FunctionPermissionHandler> list = new ArrayList<FunctionPermissionHandler>();
        for (FunctionPermission functionPermission : functionPermissionList) {
            list.add(new FunctionPermissionHandler(functionPermission));
        }
        return list;
    }

    protected void appendSecurityConfig(List<FunctionPermission> functionPermissionList) {
        String pathAnonList = this.getSecurityConfig().getPathAnonList();
        String pathAuthList = this.getSecurityConfig().getPathAuthList();
        if (pathAnonList != null) {
            for (String path : pathAnonList.split(",")) {
                functionPermissionList.add(new FunctionPermission(path, "ANON", null));
            }
        }
        if (pathAuthList != null) {
            for (String path : pathAuthList.split(",")) {
                functionPermissionList.add(new FunctionPermission(path, "AUTH", null));
            }
        }
    }

    public AuthenticationData authCheck(AuthenticationHandler handler) throws AuthenticationCheckerException {
        FunctionPermissionHandler functionPermissionHandler;
        AuthTokenInfo tokenInfo;
        if (this.isCorsDisabled() && "OPTIONS".equals(handler.getRequestMethod())) {
            return new AuthenticationData(0L, "");
        }
        String token = handler.getRequestToken();
        Long id = 0L;
        if (StringUtils.hasText((String)token) && (tokenInfo = this.tokenParser(token)) != null && !tokenInfo.isExpired()) {
            id = tokenInfo.getId();
        }
        if ((functionPermissionHandler = this.findFunctionMatcher(handler)) == null) {
            throw new AuthenticationCheckerException(AuthenticationCheckerResult.NO_PERMISSION);
        }
        if (this.hasAnonymous(handler, functionPermissionHandler)) {
            return new AuthenticationData(0L, "");
        }
        if (id == null || id == 0L) {
            throw new AuthenticationCheckerException(AuthenticationCheckerResult.NO_AUTH);
        }
        List permissions = this.getAccountLoader().loadPermissions(id);
        if (permissions == null) {
            throw new AuthenticationCheckerException(AuthenticationCheckerResult.NO_PERMISSION);
        }
        if (!this.hasPermissions(handler, permissions, functionPermissionHandler)) {
            throw new AuthenticationCheckerException(AuthenticationCheckerResult.NO_PERMISSION);
        }
        return new AuthenticationData(id, token);
    }

    protected boolean hasAnonymous(AuthenticationHandler handler, FunctionPermissionHandler functionPermissionHandler) {
        return functionPermissionHandler.hasPermission("ANON");
    }

    protected boolean hasPermissions(AuthenticationHandler handler, List<String> permissions, FunctionPermissionHandler functionPermissionHandler) {
        if (permissions == null) {
            return false;
        }
        if (permissions.size() == 0) {
            return false;
        }
        if ("AUTH".equals(functionPermissionHandler.getFunctionPermission().getPermission())) {
            return true;
        }
        for (String permission : permissions) {
            if (permission == null || !functionPermissionHandler.hasPermission(permission)) continue;
            return true;
        }
        return false;
    }

    protected AuthTokenInfo tokenParser(String token) {
        AuthTokenInfo tokenInfo;
        try {
            tokenInfo = this.getTokenBuilder().decode(token);
        }
        catch (Exception ex) {
            tokenInfo = null;
        }
        return tokenInfo;
    }

    protected FunctionPermissionHandler findFunctionMatcher(AuthenticationHandler handler) {
        String path = handler.getRequestPath();
        String method = handler.getRequestMethod();
        if ("".equals(path)) {
            path = "/";
        }
        return this.findFunctionMatcher(method, path);
    }

    protected FunctionPermissionHandler findFunctionMatcher(String method, String path) {
        return this.getAuthPathMatcher().match(method, path);
    }

    protected List<FunctionPermission> loadFunctionPermissionList() {
        ArrayList functionPermissionList = this.getAccountLoader().loadFunctionPermission();
        if (functionPermissionList == null) {
            functionPermissionList = new ArrayList();
        }
        return functionPermissionList;
    }

    public PathMatcher getAuthPathMatcher() {
        return this.authPathMatcher;
    }

    public AccountLoader getAccountLoader() {
        return this.accountLoader;
    }

    public AuthTokenBuilder getTokenBuilder() {
        return this.tokenBuilder;
    }

    public SecurityConfig getSecurityConfig() {
        return this.securityConfig;
    }

    public boolean isCorsDisabled() {
        return this.corsDisabled;
    }
}

