/*
 * Decompiled with CFR 0.152.
 */
package security.filters;

import framework.config.SecurityConfig;
import framework.crypto.AESCrypto;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import security.utils.SecurityAuthUtil;
import security.utils.SecurityTokenUtil;

public class AuthIdentityServletFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(AuthIdentityServletFilter.class);
    private SecurityConfig securityConfig;
    private AESCrypto aesCrypto;
    private final boolean isAuthIdentityHeader;
    public final String authIdentityHeaderName;
    public final String authIdentityHeaderNameSign;

    public AuthIdentityServletFilter(SecurityConfig securityConfig, AESCrypto aesCrypto) {
        this.securityConfig = securityConfig;
        this.aesCrypto = aesCrypto;
        this.isAuthIdentityHeader = StringUtils.hasText((String)securityConfig.getAuthIdentityHeader());
        this.authIdentityHeaderName = securityConfig.getAuthIdentityHeader();
        this.authIdentityHeaderNameSign = securityConfig.getAuthIdentityHeader() + "-SIGN";
    }

    private Long getAuthIdentity(HttpServletRequest servletRequest) {
        String identity = servletRequest.getHeader(this.authIdentityHeaderName);
        if (StringUtils.hasText((String)identity)) {
            return Long.parseLong(identity);
        }
        return 0L;
    }

    private String getAuthSign(HttpServletRequest servletRequest) {
        return servletRequest.getHeader(this.authIdentityHeaderNameSign);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (this.isAuthIdentityHeader) {
            HttpServletRequest request = (HttpServletRequest)servletRequest;
            HttpServletResponse response = (HttpServletResponse)servletResponse;
            Long id = this.getAuthIdentity(request);
            if (id == null) {
                if (this.getSecurityConfig().getDebugAccountId() != null) {
                    id = this.getSecurityConfig().getDebugAccountId();
                }
            } else {
                String s;
                String authSign = this.getAuthSign(request);
                if (!StringUtils.hasText((String)authSign)) {
                    response.sendError(403, "illegal access");
                    return;
                }
                try {
                    s = this.aesCrypto.decodeBase64AsString(authSign);
                }
                catch (Exception exception) {
                    s = null;
                }
                if (!StringUtils.hasText((String)s)) {
                    response.sendError(403, "illegal access");
                    return;
                }
                if (!s.equals(id + "00x")) {
                    response.sendError(403, "illegal access");
                    return;
                }
            }
            String token = SecurityTokenUtil.getRequestToken(request);
            SecurityAuthUtil.authorized(id, token);
        } else {
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    public SecurityConfig getSecurityConfig() {
        return this.securityConfig;
    }
}

