/*
 * Decompiled with CFR 0.152.
 */
package security.service;

import framework.security.Account;
import framework.security.AccountLoader;
import framework.utils.RequestUtil;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Component;
import security.vo.UserDetail;

@Component
public class UserDetailsServiceImpl
implements UserDetailsService {
    private static final Logger log = LoggerFactory.getLogger(UserDetailsServiceImpl.class);
    private AccountLoader accountLoader;

    public UserDetailsServiceImpl(AccountLoader accountLoader) {
        this.accountLoader = accountLoader;
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        Account user = this.accountLoader.loadUserByUsername(username);
        if (user == null) {
            throw new UsernameNotFoundException(RequestUtil.getMessageDefault((String)"security.userNotFound", (String)"username or password error", (Object[])new Object[0]));
        }
        List userPermission = this.accountLoader.loadPermissions(Long.valueOf(user.getId()));
        UserDetail userDetail = new UserDetail(user, userPermission);
        return userDetail;
    }

    public AccountLoader getAccountLoader() {
        return this.accountLoader;
    }
}

