/*
 * Decompiled with CFR 0.152.
 */
package security.config;

import framework.config.SecurityConfig;
import framework.exceptions.ConfigurationException;
import framework.runtime.SystemContext;
import framework.security.AccountLoader;
import framework.security.FunctionPermission;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.util.StringUtils;
import security.filters.BearerAuthenticationFilter;
import security.processor.AuthFailedProcessor;
import security.processor.AuthSuccessProcessor;
import security.processor.LogoutSuccessProcessor;
import security.processor.NoAuthProcessor;
import security.processor.NoPermissionProcessor;

public class SecurityConfiguration {
    private static final Logger log = LoggerFactory.getLogger(SecurityConfiguration.class);

    public SecurityFilterChain chain(HttpSecurity http) throws Exception {
        return (SecurityFilterChain)http.build();
    }

    public SecurityConfiguration configure(HttpSecurity http) throws Exception {
        SecurityConfig securityConfig = this.loadSecurityConfig();
        this.configure00Before(http, securityConfig);
        this.configure01CORS(http, securityConfig);
        this.configure02Login(http, securityConfig);
        this.configure03Logout(http, securityConfig);
        this.configure04Exception(http, securityConfig);
        this.configure05FunctionPermissions(http, securityConfig);
        this.configure06Anonymous(http, securityConfig);
        this.configureNoSetAuth(http, securityConfig);
        this.configure07CSRF(http, securityConfig);
        this.configure08Frame(http, securityConfig);
        this.configure09BasicAuth(http, securityConfig);
        this.configure10BearerFilter(http, securityConfig);
        this.configure11Session(http, securityConfig);
        this.configure99After(http, securityConfig);
        return this;
    }

    protected void configureNoSetAuth(HttpSecurity http, SecurityConfig securityConfig) throws Exception {
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().anyRequest()).denyAll();
    }

    protected void configure00Before(HttpSecurity http, SecurityConfig securityConfig) {
    }

    protected void configure99After(HttpSecurity http, SecurityConfig securityConfig) {
    }

    protected void configure11Session(HttpSecurity http, SecurityConfig securityConfig) throws Exception {
        if (securityConfig.getEnableSession().booleanValue()) {
            http.sessionManagement().sessionCreationPolicy(this.sessionPolicy(securityConfig));
        } else {
            http.sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS);
        }
    }

    protected void configure10BearerFilter(HttpSecurity http, SecurityConfig securityConfig) throws Exception {
        if (securityConfig.getEnableBearerToken().booleanValue()) {
            http.addFilterBefore(this.loadTokenAuthenticationFilter(securityConfig), UsernamePasswordAuthenticationFilter.class);
        }
    }

    protected void configure09BasicAuth(HttpSecurity http, SecurityConfig securityConfig) throws Exception {
        if (securityConfig.getEnableBasicAuth().booleanValue()) {
            http.httpBasic();
        }
    }

    protected void configure08Frame(HttpSecurity http, SecurityConfig securityConfig) throws Exception {
        http.headers().frameOptions().disable();
    }

    protected void configure07CSRF(HttpSecurity http, SecurityConfig securityConfig) throws Exception {
        if (securityConfig.getEnableCsrf().booleanValue()) {
            http.csrf();
        } else {
            http.csrf().disable();
        }
    }

    protected void configure06Anonymous(HttpSecurity http, SecurityConfig securityConfig) throws Exception {
        List<String> anonList = this.loadAnonymousPaths(securityConfig);
        String pathAnonList = securityConfig.getPathAnonList();
        if (StringUtils.hasText((String)pathAnonList)) {
            String[] items;
            for (String item : items = pathAnonList.split(",")) {
                if (!StringUtils.hasText((String)item)) continue;
                anonList.add(item);
            }
        }
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(anonList.toArray(new String[0]))).permitAll();
        for (String s : anonList) {
            log.info("anonymous path: {}", (Object)s);
        }
    }

    protected void configure04Exception(HttpSecurity http, SecurityConfig securityConfig) throws Exception {
        http.exceptionHandling().accessDeniedHandler((AccessDeniedHandler)this.loadNoPermissionProcessor(securityConfig)).authenticationEntryPoint((AuthenticationEntryPoint)this.loadNoAuthProcessor(securityConfig));
    }

    protected void configure03Logout(HttpSecurity http, SecurityConfig securityConfig) throws Exception {
        http.logout().logoutUrl(securityConfig.getLogoutPath()).logoutSuccessHandler((LogoutSuccessHandler)this.loadLogoutSuccessProcessor(securityConfig));
    }

    protected void configure02Login(HttpSecurity http, SecurityConfig securityConfig) throws Exception {
        ((FormLoginConfigurer)http.formLogin().loginPage(securityConfig.getLoginPath()).successHandler((AuthenticationSuccessHandler)this.loadAuthSuccessProcessor(securityConfig))).failureHandler((AuthenticationFailureHandler)this.loadAuthFailedProcessor(securityConfig));
    }

    protected void configure01CORS(HttpSecurity http, SecurityConfig securityConfig) throws Exception {
        http.cors();
    }

    protected SessionCreationPolicy sessionPolicy(SecurityConfig securityConfig) {
        return SessionCreationPolicy.IF_REQUIRED;
    }

    protected void configure05FunctionPermissions(HttpSecurity http, SecurityConfig securityConfig) throws Exception {
        List<FunctionPermission> functionPermissions = this.loadFunctionPermissionList(securityConfig);
        String pathAuthList = securityConfig.getPathAuthList();
        if (StringUtils.hasText((String)pathAuthList)) {
            String[] items = pathAuthList.split(",");
            for (String item : items) {
                if (!StringUtils.hasText((String)item)) continue;
                functionPermissions.add(new FunctionPermission(item, "AUTH", null));
            }
        }
        int counter = 0;
        if (functionPermissions != null) {
            for (FunctionPermission fp : functionPermissions) {
                if (!StringUtils.hasText((String)fp.getPath()) || !fp.getPath().startsWith("/") || !StringUtils.hasText((String)fp.getPermission())) continue;
                if (StringUtils.hasText((String)fp.getPermission())) {
                    String[] permissions = fp.getPermission().split(",");
                    if (StringUtils.hasLength((String)fp.getMethod())) {
                        HttpMethod method = null;
                        try {
                            method = HttpMethod.valueOf((String)fp.getMethod());
                        }
                        catch (Exception exception) {
                            throw new ConfigurationException("FunctionPermission invalid by " + fp.getPath(), (Throwable)exception);
                        }
                        if (permissions.length > 1) {
                            ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(method, new String[]{fp.getPath()})).hasAnyAuthority(permissions);
                        } else if (fp.getPermission().equals("AUTH")) {
                            ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(new String[]{fp.getMethod(), fp.getPath()})).authenticated();
                        } else if (fp.getPermission().equals("ANON")) {
                            ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(new String[]{fp.getMethod(), fp.getPath()})).anonymous();
                        } else {
                            ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(method, new String[]{fp.getPath()})).hasAuthority(fp.getPermission());
                        }
                    } else if (permissions.length > 1) {
                        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(new String[]{fp.getPath()})).hasAnyAuthority(permissions);
                    } else if (fp.getPermission().equals("AUTH")) {
                        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(new String[]{fp.getPath()})).authenticated();
                    } else if (fp.getPermission().equals("ANON")) {
                        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(new String[]{fp.getPath()})).anonymous();
                    } else {
                        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(new String[]{fp.getPath()})).hasAuthority(fp.getPermission());
                    }
                }
                ++counter;
            }
        }
        log.info("Load {} function permission", (Object)counter);
    }

    protected List<FunctionPermission> loadFunctionPermissionList(SecurityConfig securityConfig) {
        AccountLoader accountLoader = this.loadUserLoader(securityConfig);
        List functionPermissionList = accountLoader.loadFunctionPermission();
        return functionPermissionList;
    }

    protected List<String> loadAnonymousPaths(SecurityConfig securityConfig) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("/");
        list.add("/login");
        list.add("/register");
        list.add("/favicon.ico");
        list.add("/robots.txt");
        list.add("/js/**");
        list.add("/css/**");
        list.add("/img/**");
        list.add("/files/**");
        list.add("/swagger-ui/**");
        list.add("/swagger-resources/**");
        list.add("/v3/api-docs");
        list.add("/v2/api-docs");
        return list;
    }

    protected AuthSuccessProcessor loadAuthSuccessProcessor(SecurityConfig securityConfig) {
        return (AuthSuccessProcessor)SystemContext.getBean(AuthSuccessProcessor.class);
    }

    protected AuthFailedProcessor loadAuthFailedProcessor(SecurityConfig securityConfig) {
        return (AuthFailedProcessor)SystemContext.getBean(AuthFailedProcessor.class);
    }

    protected LogoutSuccessProcessor loadLogoutSuccessProcessor(SecurityConfig securityConfig) {
        return (LogoutSuccessProcessor)SystemContext.getBean(LogoutSuccessProcessor.class);
    }

    protected NoAuthProcessor loadNoAuthProcessor(SecurityConfig securityConfig) {
        return (NoAuthProcessor)SystemContext.getBean(NoAuthProcessor.class);
    }

    protected NoPermissionProcessor loadNoPermissionProcessor(SecurityConfig securityConfig) {
        return (NoPermissionProcessor)SystemContext.getBean(NoPermissionProcessor.class);
    }

    protected Filter loadTokenAuthenticationFilter(SecurityConfig securityConfig) {
        return (Filter)SystemContext.getBean(BearerAuthenticationFilter.class);
    }

    protected AccountLoader loadUserLoader(SecurityConfig securityConfig) {
        return (AccountLoader)SystemContext.getBean(AccountLoader.class);
    }

    protected SecurityConfig loadSecurityConfig() {
        return (SecurityConfig)SystemContext.getBean(SecurityConfig.class);
    }
}

