/*
 * Decompiled with CFR 0.152.
 */
package security.processor;

import framework.config.SecurityConfig;
import framework.utils.JsonUtil;
import framework.utils.RequestUtil;
import framework.vo.ResultInfo;
import java.io.IOException;
import java.nio.charset.Charset;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class NoPermissionProcessor
implements AccessDeniedHandler {
    private static final Logger log = LoggerFactory.getLogger(NoPermissionProcessor.class);
    @Autowired
    private SecurityConfig securityConfig;

    public void handle(HttpServletRequest request, HttpServletResponse response, AccessDeniedException accessDeniedException) throws IOException, ServletException {
        if (StringUtils.hasLength((String)this.securityConfig.getRedirectOnNoPermission())) {
            response.sendRedirect(this.securityConfig.getRedirectOnNoPermission());
            return;
        }
        response.setStatus(405);
        ResultInfo resultInfo = new ResultInfo(405, RequestUtil.getMessageDefault((String)"error.e405", (String)"No Permission", (Object[])new Object[0]));
        String s = JsonUtil.toJsonString((Object)resultInfo);
        response.setContentType("application/json");
        response.setCharacterEncoding(Charset.defaultCharset().displayName());
        response.getWriter().write(s);
    }
}

