package security.vo;

import framework.security.Account;
import lombok.Getter;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;

/**
 * 用户详情
 */
public class UserDetail implements UserDetails {

    @Getter
    private final Account account;

    public UserDetail(Account user, Collection<String> permissions) {
        Date now = new Date();
        this.account = user;
        //
        this._isAccountNonExpired = !(user.accountExpired() != null && user.accountExpired().getTime() < now.getTime());
        this._isAccountNonLocked = true;
        this._isCredentialsNonExpired = !(user.passwordExpired() != null && user.passwordExpired().getTime() < now.getTime());
        this._isEnabled = user.isEnabled();
        //build authority
        ArrayList<UserAuthority> authorities = new ArrayList<>();
        if (permissions != null) {
            for (String permission : permissions) {
                authorities.add(new UserAuthority(permission));
            }
        }
        this._authorities = authorities;
    }

    private Collection<? extends GrantedAuthority> _authorities;

    @Override
    public Collection<? extends GrantedAuthority> getAuthorities() {
        return this._authorities;
    }

    @Override
    public String getPassword() {
        return this.account.getPassword();
    }

    @Override
    public String getUsername() {
        return this.account.getUsername();
    }

    private boolean _isAccountNonExpired;

    @Override
    public boolean isAccountNonExpired() {
        return this._isAccountNonExpired;
    }

    private boolean _isAccountNonLocked;

    @Override
    public boolean isAccountNonLocked() {
        return this._isAccountNonLocked;
    }

    private boolean _isCredentialsNonExpired;

    @Override
    public boolean isCredentialsNonExpired() {
        return this._isCredentialsNonExpired;
    }

    private boolean _isEnabled;

    @Override
    public boolean isEnabled() {
        return this._isEnabled;
    }

}
