package security.processor;

import framework.config.SecurityConfig;
import framework.utils.JsonUtil;
import framework.utils.RequestUtil;
import framework.vo.ResultInfo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.charset.Charset;

/**
 * 无权访问
 */
@Slf4j
@Component
public class NoPermissionProcessor implements AccessDeniedHandler {

    @Autowired
    private SecurityConfig securityConfig;

    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response, AccessDeniedException accessDeniedException) throws IOException, ServletException {
        //转向
        if (StringUtils.hasLength(securityConfig.getRedirectOnNoPermission())) {
            response.sendRedirect(securityConfig.getRedirectOnNoPermission());
            return;
        }

        //
        response.setStatus(405);
        ResultInfo resultInfo = new ResultInfo(405, RequestUtil.getMessageDefault("error.e405", "No Permission"));
        String s = JsonUtil.toJsonString(resultInfo);
        response.setContentType("application/json");
        response.setCharacterEncoding(Charset.defaultCharset().displayName());
        response.getWriter().write(s);
    }
}
