package security.processor;

import framework.config.SecurityConfig;
import framework.utils.JsonUtil;
import framework.utils.RequestUtil;
import framework.vo.ResultInfo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.charset.Charset;

/**
 * 未登录
 */
@Slf4j
@Component
public class NoAuthProcessor implements AuthenticationEntryPoint {

    @Autowired
    private SecurityConfig securityConfig;

    @Override
    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException, ServletException {
        //转向
        if (StringUtils.hasLength(securityConfig.getRedirectOnNoAuth())) {
            response.sendRedirect(securityConfig.getRedirectOnNoAuth());
            return;
        }

        //
        response.setStatus(401);
        ResultInfo resultInfo = new ResultInfo(401, RequestUtil.getMessageDefault("error.e401", "Unauthorized"));
        //
        String s = JsonUtil.toJsonString(resultInfo);
        response.setContentType("application/json");
        response.setCharacterEncoding(Charset.defaultCharset().displayName());
        response.getWriter().write(s);
    }
}
