package security.password;

import framework.security.password.PasswordMode;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Component;

/**
 * BCrypt加密模式
 */
@Component
public class PasswordBCryptMode implements PasswordMode {
    private final PasswordEncoder passwordEncoder = new BCryptPasswordEncoder();

    @Override
    public String getName() {
        return "BCrypt";
    }

    @Override
    public String encode(String rawPassword, String salt) {
        String s = passwordEncoder.encode(rawPassword + salt);
        return s;
    }

    @Override
    public boolean matched(String rawPassword, String salt, String encodedPassword) {
        boolean isMatch = passwordEncoder.matches(rawPassword + salt, encodedPassword);
        return isMatch;
    }
}
