/*
 * Decompiled with CFR 0.152.
 */
package security.vo;

import framework.security.Account;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import security.vo.UserAuthority;

public class UserDetail
implements UserDetails {
    private final Account account;
    private Collection<? extends GrantedAuthority> _authorities;
    private boolean _isAccountNonExpired;
    private boolean _isAccountNonLocked;
    private boolean _isCredentialsNonExpired;
    private boolean _isEnabled;

    public UserDetail(Account user, Collection<String> permissions) {
        Date now = new Date();
        this.account = user;
        this._isAccountNonExpired = user.accountExpired() == null || user.accountExpired().getTime() >= now.getTime();
        this._isAccountNonLocked = true;
        this._isCredentialsNonExpired = user.passwordExpired() == null || user.passwordExpired().getTime() >= now.getTime();
        this._isEnabled = user.isEnabled();
        ArrayList<? extends GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();
        if (permissions != null) {
            for (String permission : permissions) {
                authorities.add(new UserAuthority(permission));
            }
        }
        this._authorities = authorities;
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        return this._authorities;
    }

    public String getPassword() {
        return this.account.getPassword();
    }

    public String getUsername() {
        return this.account.getUsername();
    }

    public boolean isAccountNonExpired() {
        return this._isAccountNonExpired;
    }

    public boolean isAccountNonLocked() {
        return this._isAccountNonLocked;
    }

    public boolean isCredentialsNonExpired() {
        return this._isCredentialsNonExpired;
    }

    public boolean isEnabled() {
        return this._isEnabled;
    }

    public Account getAccount() {
        return this.account;
    }
}

