/*
 * Decompiled with CFR 0.152.
 */
package security.service;

import framework.config.UserConfig;
import framework.security.Account;
import framework.security.AuthService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Configurable;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import security.vo.UserDetail;

@Configurable
public class AuthServiceImpl
implements AuthService {
    @Autowired
    private UserConfig userConfig;

    public boolean isSupperAdmin() {
        Long superAdminId = this.userConfig.getSuperAdminId();
        if (superAdminId == null) {
            return false;
        }
        if (superAdminId == 0L) {
            return false;
        }
        Long accountId = this.getAccountId();
        if (accountId == null) {
            return false;
        }
        return superAdminId.equals(accountId);
    }

    public Long getAccountId() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (!(authentication.getPrincipal() instanceof UserDetail)) {
            return null;
        }
        UserDetail detail = (UserDetail)authentication.getPrincipal();
        if (detail != null && detail.getAccount() != null) {
            return detail.getAccount().getId();
        }
        return null;
    }

    public Account getAccount() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (!(authentication.getPrincipal() instanceof UserDetail)) {
            return null;
        }
        UserDetail detail = (UserDetail)authentication.getPrincipal();
        if (detail != null && detail.getAccount() != null) {
            return detail.getAccount();
        }
        return null;
    }

    public boolean isAuthenticated() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (!(authentication.getPrincipal() instanceof UserDetail)) {
            return false;
        }
        return authentication.isAuthenticated();
    }

    public String getSecret() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        String credentials = (String)authentication.getCredentials();
        return credentials;
    }

    public boolean hasPermission(String permission) {
        if (permission == null) {
            return false;
        }
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        for (GrantedAuthority authority : authentication.getAuthorities()) {
            if (!permission.equals(authority.getAuthority())) continue;
            return true;
        }
        return false;
    }
}

