/*
 * Decompiled with CFR 0.152.
 */
package security.filters;

import framework.security.Account;
import framework.security.AccountLoader;
import framework.security.AuthInfo;
import framework.security.token.AuthTokenBuilder;
import framework.security.token.AuthTokenInfo;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.WebAuthenticationDetailsSource;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;
import security.vo.UserAuthority;
import security.vo.UserDetail;

public abstract class TokenRequestFilter
extends OncePerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(TokenRequestFilter.class);
    @Autowired
    private AuthTokenBuilder tokenBuilder;
    @Autowired
    private AccountLoader accountLoader;

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        Authentication authenticationOfChain = SecurityContextHolder.getContext().getAuthentication();
        if (authenticationOfChain != null && authenticationOfChain.isAuthenticated()) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String token = this.getRequestToken(request);
        if (!StringUtils.hasLength((String)token)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        AuthTokenInfo tokenInfo = this.tokenParser(token);
        if (tokenInfo == null) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (tokenInfo.isExpired()) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        AuthInfo authInfo = this.accountLoader.loadAuthInfo(tokenInfo.getId());
        if (authInfo == null || authInfo.getAccount() == null) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        Account account = authInfo.getAccount();
        try {
            account.statusCheck();
        }
        catch (Exception exception) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            log.warn("Account " + account.getUsername() + "/" + account.getId() + " token check fail: " + exception.getMessage());
            return;
        }
        List authorities = authInfo.getPermissions().stream().map(i -> new UserAuthority((String)i)).collect(Collectors.toList());
        UserDetail detail = new UserDetail(account, authInfo.getPermissions());
        UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)detail, (Object)token, authorities);
        authentication.setDetails((Object)new WebAuthenticationDetailsSource().buildDetails(request));
        SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    protected AuthTokenInfo tokenParser(String token) {
        AuthTokenInfo tokenInfo;
        try {
            tokenInfo = this.tokenBuilder.decode(token);
        }
        catch (Exception ex) {
            tokenInfo = null;
        }
        return tokenInfo;
    }

    protected abstract String getRequestToken(HttpServletRequest var1);
}

