/*
 * Decompiled with CFR 0.152.
 */
package security.config;

import framework.captcha.Captcha;
import framework.config.SecurityConfig;
import framework.security.AccountLoader;
import framework.security.AuthService;
import framework.security.password.PasswordService;
import framework.security.token.AuthTokenBuilder;
import org.springframework.cache.CacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.web.SecurityFilterChain;
import security.config.SecurityConfiguration;

@EnableWebSecurity
@Configuration
public class SecurityBeanConfiguration {
    @Bean
    public AuthTokenBuilder loadTokenBuilder(SecurityConfiguration configuration, SecurityConfig securityConfig) {
        return configuration.newTokenBuilder(securityConfig);
    }

    @Bean
    public PasswordService loadPasswordService(SecurityConfiguration configuration, SecurityConfig securityConfig) {
        return configuration.newPasswordService(securityConfig);
    }

    @Bean
    public AuthService loadAuthService(SecurityConfiguration configuration, SecurityConfig securityConfig) {
        return configuration.newAuthService(securityConfig);
    }

    @Bean
    public AccountLoader loadAccountLoader(SecurityConfiguration configuration, SecurityConfig securityConfig) {
        return configuration.newAccountLoader(securityConfig);
    }

    @Bean
    public Captcha loadCaptchaService(SecurityConfiguration configuration, CacheManager cacheManager) {
        return configuration.newCaptcha(cacheManager);
    }

    @Bean
    public SecurityFilterChain loadSecurityFilterChain(HttpSecurity http, SecurityConfiguration configuration) throws Exception {
        return configuration.configure(http).chain(http);
    }
}

