package security.processor;

import framework.config.SecurityConfig;
import framework.security.Account;
import framework.security.AccountLoader;
import framework.utils.JsonUtil;
import framework.vo.ResultInfo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import security.vo.LoginInfo;
import security.vo.UserDetail;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.charset.Charset;

/**
 * 退出登录
 */
@Slf4j
@Component
@SuppressWarnings("unchecked")
public class LogoutSuccessProcessor implements LogoutSuccessHandler {

    @Autowired
    private AccountLoader accountLoader;

    @Autowired
    private SecurityConfig securityConfig;

    @Override
    public void onLogoutSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        if (authentication == null)
            return;

        UserDetail detail = (UserDetail) authentication.getPrincipal();
        if (detail == null)
            return;
        Account account = detail.getAccount();

        //更新数据库
        this.accountLoader.logoutSuccessful(account.getId());

        //转向
        if (StringUtils.hasText(securityConfig.getRedirectOnLogoutSuccess())) {
            response.sendRedirect(securityConfig.getRedirectOnLogoutSuccess());
            return;
        }

        //
        LoginInfo loginInfo = new LoginInfo();
        loginInfo.setId(account.getId());
        loginInfo.setUsername(account.getUsername());
        loginInfo.setName(account.getName());

        //
        ResultInfo<LoginInfo> resultInfo = new ResultInfo(loginInfo);

        //
        String s = JsonUtil.toJsonString(resultInfo);
        response.setContentType("application/json");
        response.setCharacterEncoding(Charset.defaultCharset().displayName());
        response.getWriter().write(s);
    }
}
