/*
 * Decompiled with CFR 0.152.
 */
package security.processor;

import framework.config.SecurityConfig;
import framework.security.AccountLoader;
import framework.utils.JsonUtil;
import framework.vo.ResultInfo;
import java.io.IOException;
import java.nio.charset.Charset;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.LockedException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import security.exceptions.CaptchaException;
import security.service.CaptchaFailCache;

@Component
public class AuthFailedProcessor
implements AuthenticationFailureHandler {
    private static final Logger log = LoggerFactory.getLogger(AuthFailedProcessor.class);
    @Autowired
    private AccountLoader accountLoader;
    @Autowired
    private CaptchaFailCache captchaFailCache;
    @Autowired
    private SecurityConfig securityConfig;

    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException, ServletException {
        boolean noLog;
        ResultInfo resultInfo = new ResultInfo().failed(exception.getMessage());
        String username = request.getParameter("username");
        boolean bl = noLog = exception instanceof LockedException || exception instanceof CaptchaException;
        if (!noLog && StringUtils.hasText((String)username)) {
            this.accountLoader.loginUnsuccessful(username, exception.getMessage());
        }
        if (StringUtils.hasText((String)username)) {
            this.captchaFailCache.failed(username);
        }
        if (StringUtils.hasLength((String)this.securityConfig.getRedirectOnAuthFailed())) {
            response.sendRedirect(this.securityConfig.getRedirectOnAuthFailed());
            return;
        }
        String s = JsonUtil.toJsonString((Object)resultInfo);
        response.setContentType("application/json");
        response.setCharacterEncoding(Charset.defaultCharset().displayName());
        response.getWriter().write(s);
    }
}

