package security.config;

import framework.captcha.Captcha;
import framework.config.SecurityConfig;
import framework.security.AccountLoader;
import framework.security.AuthService;
import framework.security.password.PasswordService;
import framework.security.token.AuthTokenBuilder;
import org.springframework.cache.CacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.web.SecurityFilterChain;

/**
 * Token 构造器
 */
@EnableWebSecurity
@Configuration
public class SecurityBeanConfiguration {

    /**
     * 配置 token builder
     *
     * @return
     */
    @Bean
    public AuthTokenBuilder loadTokenBuilder(SecurityConfiguration configuration, SecurityConfig securityConfig) {
        return configuration.newTokenBuilder(securityConfig);
    }

    /**
     * 配置 密码服务
     *
     * @return
     */
    @Bean
    public PasswordService loadPasswordService(SecurityConfiguration configuration, SecurityConfig securityConfig) {
        return configuration.newPasswordService(securityConfig);
    }

    /**
     * 配置 密码服务
     *
     * @return
     */
    @Bean
    public AuthService loadAuthService(SecurityConfiguration configuration, SecurityConfig securityConfig) {
        return configuration.newAuthService(securityConfig);
    }

    /**
     * 配置 账号加载器
     *
     * @return
     */
    @Bean
    public AccountLoader loadAccountLoader(SecurityConfiguration configuration, SecurityConfig securityConfig) {
        return configuration.newAccountLoader(securityConfig);
    }

    /**
     * 加载创建码服务
     *
     * @param configuration
     * @param cacheManager
     * @return
     */
    @Bean
    public Captcha loadCaptchaService(SecurityConfiguration configuration, CacheManager cacheManager) {
        return configuration.newloadCaptcha(cacheManager);
    }

    /**
     * 注入安全配置链
     *
     * @param http
     * @return
     * @throws Exception
     */
    @Bean
    public SecurityFilterChain loadSecurityFilterChain(HttpSecurity http, SecurityConfiguration configuration) throws Exception {
        return configuration.configure(http).chain(http);
    }
}
