/*
 * Decompiled with CFR 0.152.
 */
package security.processor;

import framework.security.AccountLoader;
import framework.utils.JsonUtil;
import framework.vo.ResultInfo;
import java.io.IOException;
import java.nio.charset.Charset;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.LockedException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class AuthFailedProcessor
implements AuthenticationFailureHandler {
    private static final Logger log = LoggerFactory.getLogger(AuthFailedProcessor.class);
    @Autowired
    private AccountLoader accountLoader;

    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException, ServletException {
        String username;
        ResultInfo resultInfo = new ResultInfo().failed(exception.getMessage());
        if (!(exception instanceof LockedException) && StringUtils.hasText((String)(username = request.getParameter("username")))) {
            this.accountLoader.loginUnsuccessful(username, exception.getMessage());
        }
        String s = JsonUtil.toJsonString((Object)resultInfo);
        response.setContentType("application/json");
        response.setCharacterEncoding(Charset.defaultCharset().displayName());
        response.getWriter().write(s);
    }
}

