package security.processor;

import framework.security.AccountLoader;
import framework.utils.JsonUtil;
import framework.vo.ResultInfo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.LockedException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.charset.Charset;

/**
 * 授权失败
 */
@Slf4j
@Component
public class AuthFailedProcessor implements AuthenticationFailureHandler {

    @Autowired
    private AccountLoader accountLoader;

    @Override
    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException, ServletException {
        ResultInfo resultInfo = new ResultInfo().failed(exception.getMessage());
        // 非登录锁定异常，记录登录失败记录
        if (!(exception instanceof LockedException)) {
            String username = request.getParameter("username");
            if (StringUtils.hasText(username)) {
                accountLoader.loginUnsuccessful(username, exception.getMessage());
            }
        }
        //
        String s = JsonUtil.toJsonString(resultInfo);
        response.setContentType("application/json");
        response.setCharacterEncoding(Charset.defaultCharset().displayName());
        response.getWriter().write(s);
    }
}
