package security.service;

import framework.security.Account;
import framework.security.AccountLoader;
import framework.utils.RequestUtil;
import lombok.Getter;
import lombok.extern.slf4j.Slf4j;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Component;
import security.vo.UserDetail;

import java.util.Collection;

@Slf4j
@Component
public class UserDetailsServiceImpl implements UserDetailsService {

    /**
     * 获取用户加载器
     *
     * @return
     */
    @Getter
    private AccountLoader accountLoader;

    public UserDetailsServiceImpl(AccountLoader accountLoader) {
        this.accountLoader = accountLoader;
    }


    @Override
    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        //
        Account user = this.accountLoader.loadUserByUsername(username);
        if (user == null)
            throw new UsernameNotFoundException(RequestUtil.getMessageDefault("security.userNotFound", "username or password error"));

        //权限加载
        Collection<String> userPermission = this.accountLoader.loadPermissions(user.getId());

        //
        UserDetail userDetail = new UserDetail(user, userPermission);
        return userDetail;
    }

}
