package security.service;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class CaptchaFailCache {

    private final String CACHE_NAME = "Captcha";

    @Autowired
    private CacheManager cacheManager;

    private String buildKey(String username) {
        return ("CAPTHCA_FAIL_" + username).toUpperCase();
    }

    /**
     * 在一定周期内发生了错误
     *
     * @param username
     */
    public void failed(String username) {
        String key = this.buildKey(username);
        Cache cache = cacheManager.getCache(CACHE_NAME);
        cache.put(key, "1");
    }

    /**
     * 移除用户异常记录
     *
     * @param username
     */
    public void remove(String username) {
        String key = this.buildKey(username);
        Cache cache = cacheManager.getCache(CACHE_NAME);
        cache.evict(key);
    }

    /**
     * 是否在一定周期内存在失败
     *
     * @param username
     * @return
     */
    public boolean hasFailed(String username) {
        String key = this.buildKey(username);
        Cache cache = cacheManager.getCache(CACHE_NAME);
        String s = cache.get(key, String.class);
        return StringUtils.hasText(s);
    }

}
