package security.config;

import framework.config.SecurityConfig;
import framework.security.token.AuthTokenBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * Token 构造器
 */
@Configuration
public class TokenConfiguration {
    /**
     * 构建 token builder
     *
     * @return
     */
    @Bean
    public AuthTokenBuilder tokenBuilder(SecurityConfig securityConfig) {
        String secret = securityConfig.getTokenSecret();
        return new AuthTokenBuilder(secret);
    }
}
