/*
 * Decompiled with CFR 0.152.
 */
package security.processor;

import framework.security.Account;
import framework.security.AccountLoader;
import framework.utils.JsonUtil;
import framework.vo.ResultInfo;
import java.io.IOException;
import java.nio.charset.Charset;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.stereotype.Component;
import security.vo.LoginInfo;
import security.vo.UserDetail;

@Component
public class LogoutSuccessProcessor
implements LogoutSuccessHandler {
    private static final Logger log = LoggerFactory.getLogger(LogoutSuccessProcessor.class);
    @Autowired
    private AccountLoader accountLoader;

    public void onLogoutSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        if (authentication == null) {
            return;
        }
        UserDetail detail = (UserDetail)authentication.getPrincipal();
        if (detail == null) {
            return;
        }
        Account account = detail.getAccount();
        this.accountLoader.logoutSuccessful(Long.valueOf(account.getId()));
        LoginInfo loginInfo = new LoginInfo();
        loginInfo.setId(account.getId());
        loginInfo.setUsername(account.getUsername());
        loginInfo.setName(account.getName());
        ResultInfo resultInfo = new ResultInfo((Object)loginInfo);
        String s = JsonUtil.toJsonString((Object)resultInfo);
        response.setContentType("application/json");
        response.setCharacterEncoding(Charset.defaultCharset().displayName());
        response.getWriter().write(s);
    }
}

