package security.filters;

import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

/**
 * Token 认证
 */
@Component
public class TokenAuthenticationFilter extends TokenRequestFilter {

    /**
     * get token
     *
     * @param request
     * @return
     */
    @Override
    protected String getRequestToken(HttpServletRequest request) {
        String bearerToken = request.getHeader("Authorization");
        String token;
        if (StringUtils.hasLength(bearerToken) && bearerToken.startsWith("Bearer ")) {
            token = bearerToken.substring(7);
        } else if (StringUtils.hasLength(request.getParameter("TOKEN"))) {
            token = request.getParameter("TOKEN");
        } else {
            token = null;
            if (request.getCookies() != null) {
                for (Cookie cookie : request.getCookies()) {
                    if ("TOKEN".equals(cookie.getName())) {
                        if (cookie.getValue() != null) {
                            token = cookie.getValue().trim();
                        }
                        break;
                    }
                }
            }
        }
        return token;
    }

}
