package security.processor;

import framework.security.Account;
import framework.security.AccountLoader;
import framework.utils.JsonUtil;
import framework.vo.ResultInfo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.stereotype.Component;
import security.vo.LoginInfo;
import security.vo.UserDetail;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.charset.Charset;

/**
 * 退出登录
 */
@Slf4j
@Component
@SuppressWarnings("unchecked")
public class LogoutSuccessProcessor implements LogoutSuccessHandler {

    @Autowired
    private AccountLoader accountLoader;

    @Override
    public void onLogoutSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        if (authentication == null)
            return;

        UserDetail detail = (UserDetail) authentication.getPrincipal();
        if (detail == null)
            return;
        Account account = detail.getAccount();

        //更新数据库
        this.accountLoader.logoutSuccessful(account.getId());

        //
        LoginInfo loginInfo = new LoginInfo();
        loginInfo.setId(account.getId());
        loginInfo.setUsername(account.getUsername());
        loginInfo.setName(account.getName());

        //
        ResultInfo<LoginInfo> resultInfo = new ResultInfo(loginInfo);

        //
        String s = JsonUtil.toJsonString(resultInfo);
        response.setContentType("application/json");
        response.setCharacterEncoding(Charset.defaultCharset().displayName());
        response.getWriter().write(s);
    }
}
