package security.filters;

import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import javax.servlet.http.HttpServletRequest;

/**
 * Bearer 认证
 */
@Component
public class BearerAuthenticationFilter extends TokenAuthenticationFilter {

    /**
     * get token
     *
     * @param request
     * @return
     */
    @Override
    protected String getRequestToken(HttpServletRequest request) {
        String bearerToken = request.getHeader("Authorization");
        String token;
        if (StringUtils.hasLength(bearerToken) && bearerToken.startsWith("Bearer ")) {
            token = bearerToken.substring(7);
        } else if (StringUtils.hasLength(request.getParameter("TOKEN"))) {
            token = request.getParameter("TOKEN");
        } else {
            token = null;
        }
        return token;
    }

}
