/*
 * Decompiled with CFR 0.152.
 */
package security.provider;

import framework.captcha.Captcha;
import framework.config.SecurityConfig;
import framework.security.Account;
import framework.security.AccountLoader;
import framework.security.RegApproval;
import framework.security.password.PasswordService;
import framework.utils.RequestUtil;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.authentication.LockedException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.authentication.dao.DaoAuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import security.exceptions.CaptchaException;
import security.vo.UserDetail;

@Component
public class AuthenticationProvider
extends DaoAuthenticationProvider {
    @Autowired
    private Captcha captcha;
    @Autowired
    private SecurityConfig securityConfig;
    @Autowired
    private PasswordService passwordService;
    @Autowired
    private AccountLoader accountLoader;

    public AuthenticationProvider(UserDetailsService userDetailsService) {
        super.setUserDetailsService(userDetailsService);
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        String username;
        int loginFailLimit;
        if (this.securityConfig.getEnableLoginCaptcha().booleanValue()) {
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            String _captcha = request.getParameter("captcha");
            String _captchaId = request.getParameter("captchaId");
            this.validateCaptcha(_captchaId, _captcha);
        }
        if ((loginFailLimit = this.accountLoader.loginFailLimit(username = (String)authentication.getPrincipal())) > 0) {
            throw new LockedException(RequestUtil.getMessageDefault((String)"security.loginFailLimit", (String)"Login failure too many times, limit login {0} minutes", (Object[])new Object[]{(int)Math.ceil((double)loginFailLimit / 60.0) + ""}));
        }
        return super.authenticate(authentication);
    }

    protected void additionalAuthenticationChecks(UserDetails userDetails, UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {
        String encodePassword;
        String salt;
        Account account = ((UserDetail)userDetails).getAccount();
        if (authentication.getCredentials() == null) {
            this.logger.debug((Object)"Failed to authenticate since no credentials provided");
            throw new BadCredentialsException(this.messages.getMessage("AbstractUserDetailsAuthenticationProvider.badCredentials", "Bad credentials"));
        }
        String rawPassword = authentication.getCredentials().toString();
        if (!this.passwordService.matched(rawPassword, salt = account.getPasswordSalt(), encodePassword = userDetails.getPassword())) {
            this.logger.debug((Object)"Failed to authenticate since password does not match stored value");
            throw new BadCredentialsException(this.messages.getMessage("AbstractUserDetailsAuthenticationProvider.badCredentials", "Bad credentials"));
        }
        if (account.getRegApproval() != null && !RegApproval.Agree.equals((Object)account.getRegApproval())) {
            if (RegApproval.Reject.equals((Object)account.getRegApproval())) {
                throw new DisabledException(RequestUtil.getMessageDefault((String)"security.userRejectApproved", (String)"Registration approval is rejected, the account is unavailable", (Object[])new Object[0]));
            }
            if (RegApproval.Waiting.equals((Object)account.getRegApproval())) {
                throw new DisabledException(RequestUtil.getMessageDefault((String)"security.userWaitingApproved", (String)"Waiting for registration approval, the account is unavailable", (Object[])new Object[0]));
            }
        }
    }

    protected void validateCaptcha(String captchaId, String captcha) {
        if (!StringUtils.hasText((String)captchaId)) {
            throw new CaptchaException("Not set captchaId");
        }
        if (!StringUtils.hasText((String)captcha)) {
            throw new CaptchaException(RequestUtil.getMessageDefault((String)"security.captcha.empty", (String)"Please input captcha code", (Object[])new Object[0]));
        }
        boolean checkSuccess = this.captcha.check(captchaId, captcha);
        if (!checkSuccess) {
            throw new CaptchaException(RequestUtil.getMessageDefault((String)"security.captcha.invalid", (String)"Captcha code error", (Object[])new Object[0]));
        }
    }
}

